~VERSION INFORMATION
VERS.           2.0   :CWLS Log ASCII Standard - VERSION 2.0
WRAP.           NO    :One Line per depth step
PROD.  Schlumberger   :LAS Producer
PROG.  DLIS to ASCII 17C0-154                          :LAS Program name and version
CREA.        2010/04/21 06:26                          :LAS Creation date {YYYY/MM/DD hh:mm}
DLIS_CREA.  2010-Apr-21 01:27                          :DLIS Creation date and time {YYYY-MMM-DD hh:mm}
SOURCE.     AIT_TLD_MCFL_CNL_021PUP.DLIS               :DLIS File Name
FILE-ID.     AIT_TLD_MCFL_CNL_021PUP                   :File Identification Number
#--------------------------------------------------
~WELL INFORMATION
#MNEM.UNIT      DATA             DESCRIPTION
#---- ------ --------------   -----------------------------
STRT .M      1794.0528       :START DEPTH     
STOP .M      1906.0668       :STOP DEPTH     
STEP .M       0.1524         :STEP     
NULL .          -999.25      :NULL VALUE
COMP .        Nalcor Energy Oil and Gas                :COMPANY
WELL .        Nalcor et al Seamus 1                    :WELL
FLD  .        Parson's Pond                            :FIELD
LOC  .        Latitude: 49.98 N                        :LOCATION
CNTY .        Stoneham #11                             :COUNTY
STAT .        Newfoundland                             :STATE
CTRY .                                                 :COUNTRY
API  .                                                 :API NUMBER
UWI  .                                                 :UNIQUE WELL ID
DATE .        20-Apr-2010                              :LOG DATE {DD-MMM-YYYY}
SRVC .        Schlumberger                             :SERVICE COMPANY
LATI .DEG     46 DEG 23 MIN 57.8 S                     :LATITUDE
LONG .DEG     48 DEG 27 MIN 52.1 S                     :LONGITUDE
GDAT .                                                 :GeoDetic Datum
SECT .        49.98 N                                  :Section
TOWN .        57.70 W                                  :Township
#-----------------------------------------------------------------------------
~PARAMETER INFORMATION
#MNEM.UNIT    VALUE                      DESCRIPTION
#---- -----   --------------------       ------------------------
RUN  .          Run 1                    :RUN NUMBER
PDAT .        Ground Level               :Permanent Datum
EPD  .M          20.690001               :Elevation of Permanent Datum above Mean Sea Level
LMF  .          Kelly Bushing            :Logging Measured From (Name of Logging Elevation Reference)
APD  .M           6.299999               :Elevation of Depth Reference (LMF) above Permanent Datum
#-----------------------------------------------------------------------------
~CURVE INFORMATION
#MNEM.UNIT   API CODE                                  DESCRIPTION
#---- -----  --------                                  -----------------------
DEPT .M                                                :DEPTH (BOREHOLE) {F10.4}
AO10 .OHMM                                             :Array Induction One Foot Resistivity A10 {F13.4}
AO20 .OHMM                                             :Array Induction One Foot Resistivity A20 {F13.4}
AO30 .OHMM                                             :Array Induction One Foot Resistivity A30 {F13.4}
AO60 .OHMM                                             :Array Induction One Foot Resistivity A60 {F13.4}
AO90 .OHMM                                             :Array Induction One Foot Resistivity A90 {F13.4}
BS   .MM                                               :Bit Size {F13.4}
GR   .GAPI                                             :Gamma-Ray {F13.4}
HCAL .MM                                               :HRCC Cal. Caliper {F13.4}
HDPH_LIM.V/V                                           :HiRes Density Porosity (matrix Limestone) {F13.4}
HDPH_SAN.V/V                                           :HiRes Density Porosity (matrix Sandstone) {F13.4}
HDRA .K/M3                                             :HRDD Density Correction {F13.4}
HNPO_LIM.V/V                                           :HiRes Enhanced Thermal Neutron Porosity (matrix Limestone) {F13.4}
HNPO_SAN.V/V                                           :HiRes Enhanced Thermal Neutron Porosity (matrix Sandstone) {F13.4}
PEF8 .                                                 :HRDD High Resolution Formation Photoelectric Factor {F13.4}
RHO8 .K/M3                                             :HRDD High Resolution Formation Density {F13.4}
SP   .MV                                               :SP Shifted {F13.4}
TENS .LBF                                              :Cable Tension {F13.4}
#-----------------------------------------------------------------------------
# 
#     DEPT        AO10         AO20         AO30         AO60         AO90         BS           GR           HCAL       HDPH_LIM     HDPH_SAN       HDRA       HNPO_LIM     HNPO_SAN       PEF8         RHO8         SP           TENS
#
~A  
 1794.0528      83.3345     130.0269     622.8309     818.3479     584.9763     311.0000      38.7353     345.2200      -0.0016      -0.0380      -2.6553      -0.0106       0.0120       4.9566    2720.1565    -169.3125    3686.0000
 1794.2052      85.5819     105.0010     439.9217     905.9988     607.2598     311.0000      37.2142     345.2200      -0.0016      -0.0380      -2.6553      -0.0106       0.0120       4.9566    2720.1565    -169.7500    3684.0000
 1794.3576      87.5882     104.4298     287.3312     742.5801     489.6524     311.0000      38.4311     345.0379      -0.0016      -0.0380      -2.6553      -0.0102       0.0126       4.9566    2720.1565    -168.2500    3663.0000
 1794.5100      87.9737     144.4347     438.4563     610.5237     404.4091     311.0000      37.1290     344.8558      -0.0016      -0.0380      -2.6553      -0.0119       0.0108       4.9566    2720.1565    -168.0000    3695.0000
 1794.6624     106.0183     273.5711     898.4162     283.8113     205.9963     311.0000      40.3876     345.5842      -0.0016      -0.0380      -2.6553      -0.0150       0.0077       4.9566    2720.1565    -167.4375    3664.0000
 1794.8148     107.8950     529.2126    1950.0000     457.7897     323.9152     311.0000      42.9088     346.1306      -0.0016      -0.0380      -2.6553      -0.0133       0.0097       4.9566    2720.1565    -167.4375    3713.0000
 1794.9672      96.5807     657.8624    1950.0000     381.4851     276.8015     311.0000      51.6339     345.5842      -0.0016      -0.0380      -2.7723      -0.0128       0.0115       4.9889    2712.6553    -167.4375    3722.0000
 1795.1196      97.0190     340.1238     734.4798     362.6901     278.4999     311.0000      67.3937     345.0379      -0.0023      -0.0387      -1.3304      -0.0036       0.0231       4.8439    2713.8972    -167.4375    3692.0000
 1795.2720      83.6370     159.5272     344.6555     370.9101     283.0020     311.0000      82.7191     343.0348       0.0155      -0.0203      -0.7277       0.0265       0.0573       4.3643    2683.4587    -166.6875    3680.0000
 1795.4244      93.3411     102.5183     206.0586     323.3230     229.6589     311.0000      80.3662     342.7616      -0.0023      -0.0388      -3.0136       0.0395       0.0719       4.4098    2714.0037    -166.1875    3688.0000
 1795.5768      99.7633     135.8346     351.3165     515.0002     385.7857     311.0000      65.2359     343.8542      -0.0039      -0.0404      -5.2423       0.0174       0.0480       4.7362    2716.6907    -165.4375    3734.0000
 1795.7292      99.4156     154.8619     425.8000     524.0106     399.6613     311.0000      49.3292     343.8542      -0.0264      -0.0637      -3.7253      -0.0073       0.0199       5.0107    2755.1118    -165.2500    3745.0000
 1795.8816     105.2500     221.2172     517.1060     445.8619     364.0324     311.0000      42.5232     343.0348      -0.0264      -0.0637      -0.6280      -0.0094       0.0164       5.0031    2755.0750    -165.0625    3762.0000
 1796.0340      95.1606     242.2848     516.5827     426.2277     310.1275     311.0000      42.1057     340.3032      -0.0237      -0.0609       1.1387      -0.0123       0.0128       4.8655    2750.4895    -165.3750    3723.0000
 1796.1864     125.8107     485.7339     835.2587     438.4871     356.8654     311.0000      40.8756     340.3032      -0.0168      -0.0538       0.5960      -0.0031       0.0231       4.9283    2738.7424    -164.4375    3694.0000
 1796.3388     131.2993     414.3601     887.7019     704.7415     418.0881     311.0000      45.2175     337.8448      -0.0136      -0.0504       0.1216       0.0105       0.0383       5.0411    2733.2314    -163.8750    3752.0000
 1796.4912     118.4469     208.2330     441.4064     419.7541     281.6307     311.0000      44.1804     336.6611      -0.0101      -0.0468       0.6680      -0.0018       0.0254       4.9282    2727.2256    -162.9375    3786.0000
 1796.6436     133.0531     208.9668     704.6122     801.3871     583.3994     311.0000      42.8622     337.2985      -0.0199      -0.0570       1.3099       0.0018       0.0288       4.8621    2744.0679    -162.3125    3762.0000
 1796.7960     147.3308     227.0080     758.4242     810.7920     668.9077     311.0000      36.0988     338.1179      -0.0189      -0.0560       0.4280      -0.0038       0.0222       4.9046    2742.3982    -162.1250    3741.0000
 1796.9484     149.9149     239.5037     800.8967     747.4854     619.3854     311.0000      35.2968     337.5716      -0.0161      -0.0531      -0.6158      -0.0115       0.0131       4.9267    2737.5437    -160.9375    3709.0000
 1797.1008     114.0382     175.2120     476.9821     397.1413     351.5880     311.0000      34.9820     335.3864      -0.0080      -0.0446      -1.5256      -0.0069       0.0177       5.0243    2723.6084    -159.2500    3713.0000
 1797.2532     122.3982     220.4595     259.1242     233.4079     213.0685     311.0000      37.4278     336.8432      -0.0038      -0.0403      -0.1917      -0.0107       0.0144       5.0501    2716.5515    -157.6875    3693.0000
 1797.4056     138.7867     408.8613     413.7630     385.5087     312.0213     311.0000      44.2234     338.6642      -0.0008      -0.0372       0.0494      -0.0072       0.0186       5.1170    2711.3345    -157.6875    3714.0000
 1797.5580     148.2878     814.8973     598.3461     515.3025     443.2407     311.0000      54.0699     339.7569      -0.0088      -0.0454      -0.3436       0.0045       0.0321       4.9986    2724.9675    -156.6250    3735.0000
 1797.7104     158.9329     372.4564     380.0012     385.7824     333.8396     311.0000      58.6208     330.1053      -0.0124      -0.0492      -2.7835       0.0258       0.0567       4.8267    2731.1284    -153.7500    3693.0000
 1797.8628      98.4402     126.8682     153.5993     148.3957     131.4696     311.0000      55.5679     327.5558      -0.0100      -0.0467      -3.2797       0.0312       0.0633       4.6894    2727.1099    -152.5625    3733.0000
 1798.0152     130.6040     163.7600     206.9398     152.9629     137.2399     311.0000      50.0922     327.7379      -0.0028      -0.0393      -3.7727       0.0077       0.0380       4.8728    2714.8701    -151.0625    3737.0000
 1798.1676     171.5301     281.7409     458.9951     333.8698     305.4739     311.0000      46.7074     327.7379      -0.0102      -0.0469      -1.1983       0.0076       0.0368       4.9142    2727.4487    -148.8750    3637.0000
 1798.3200     143.4614     248.1812     470.7164     297.2668     274.0497     311.0000      44.4903     323.9137       0.0012      -0.0352      -0.4194       0.0093       0.0385       4.8003    2708.0173    -147.8750    3643.0000
 1798.4724     166.2353     272.8152     394.4320     259.1707     239.4800     311.0000      44.5519     323.7316       0.0016      -0.0347       0.3998       0.0091       0.0380       4.8236    2707.2810    -147.7500    3677.0000
 1798.6248     133.7010     389.2493     829.3603     315.7033     286.5131     311.0000      45.7058     323.0943      -0.0049      -0.0414       0.8779       0.0011       0.0291       4.8949    2718.3811    -145.3125    3669.0000
 1798.7772     150.5247     447.0110     685.5997     373.3128     338.4267     311.0000      44.1711     322.5479      -0.0150      -0.0519       2.0144      -0.0026       0.0245       4.9041    2735.6086    -142.5000    3736.0000
 1798.9296     138.4850     328.5728     584.5420     261.0757     225.6251     311.0000      40.4005     322.6390      -0.0106      -0.0473       2.6906       0.0003       0.0271       4.8187    2728.0950    -140.6875    3709.0000
 1799.0820     178.7802     428.9992    1298.4622     699.3962     616.1381     311.0000      38.7781     322.4569      -0.0028      -0.0393       2.5575      -0.0037       0.0225       4.9980    2714.7734    -138.1250    3728.0000
 1799.2344     219.6994     488.7284    1872.6722    1760.4014    1713.4825     311.0000      36.0306     323.0032      -0.0062      -0.0428       1.9984       0.0025       0.0286       4.9574    2720.6260    -137.6250    3745.0000
 1799.3868     250.8800     447.0029    1440.5498    1574.1871    1503.5944     311.0000      35.1651     323.1853      -0.0019      -0.0383       1.5364      -0.0077       0.0176       5.0707    2713.2092    -133.6875    3727.0000
 1799.5392     247.1274     349.7310     931.6393    1476.5358    1431.6335     311.0000      33.3510     323.9137      -0.0073      -0.0439       1.1268      -0.0070       0.0183       4.9987    2722.4900    -131.5625    3708.0000
 1799.6916     155.3667     272.9622     453.7739     867.7984     828.4993     311.0000      34.6680     324.2780      -0.0100      -0.0467       4.9732      -0.0082       0.0169       4.9442    2727.1372    -128.6250    3692.0000
 1799.8440     141.9794     183.8663     266.8325     530.3420     502.1166     311.0000      36.6061     325.3706      -0.0156      -0.0525      10.5834      -0.0033       0.0223       4.9946    2736.6738    -127.3750    3726.0000
 1799.9964     114.8028     193.8267     206.2754     297.2865     278.2812     311.0000      38.2537     324.7332      -0.0207      -0.0578      13.9296      -0.0080       0.0181       4.9006    2745.4050    -124.1875    3752.0000
 1800.1488     127.6759     277.3923     265.7754     262.0339     250.7920     311.0000      41.8136     325.0064      -0.0266      -0.0639      19.7654      -0.0084       0.0189       4.9525    2755.4946    -120.3750    3766.0000
 1800.3012     152.4360     565.5554     336.6529     206.0152     199.8413     311.0000      52.2083     325.0064      -0.0259      -0.0632      27.0469       0.0057       0.0358       4.8976    2754.2458    -118.6250    3733.0000
 1800.4536      98.5610     346.8582     199.5316     136.2974     135.6367     311.0000      61.9861     324.8242      -0.0185      -0.0555      35.6762       0.0346       0.0683       4.5487    2741.6003    -117.5625    3716.0000
 1800.6060      66.8145     167.1566     115.2369      80.4432      79.7731     311.0000      67.7856     325.3706      -0.0157      -0.0526      44.1563       0.0418       0.0776       4.7879    2736.8245    -114.5625    3713.0000
 1800.7584     109.5543     164.1338     123.7437      88.5262      87.8767     311.0000      65.9898     327.0095      -0.0079      -0.0446      40.3113       0.0467       0.0841       4.6923    2723.5496    -111.6875    3698.0000
 1800.9108      85.5728     146.2351     200.8958     151.8741     150.5691     311.0000      63.5683     327.1916       0.0096      -0.0264      27.5621       0.0402       0.0774       4.6320    2693.5771    -109.2500    3670.0000
 1801.0632     142.6600     251.5645     579.6998     644.4333     632.4550     311.0000      60.8108     332.6548       0.0258      -0.0096       9.2971       0.0499       0.0872       4.7420    2665.8469    -108.8125    3615.0000
 1801.2156     130.1117     163.2076     337.9085     696.1422     689.2197     311.0000      57.4849     325.9169       0.0248      -0.0107       1.3649       0.0364       0.0719       4.6848    2667.6641    -107.5625    3719.0000
 1801.3680     134.3202      83.0451     176.1004     773.4980     761.1978     311.0000      51.6132     326.0990       0.0095      -0.0266       2.8446       0.0248       0.0579       4.7988    2693.8098    -104.6250    3720.0000
 1801.5204     220.0513     155.5175     237.7874     341.0698     335.0040     311.0000      46.4379     327.3737      -0.0001      -0.0365       3.0615       0.0083       0.0384       5.0101    2710.2551    -102.0625    3732.0000
 1801.6728     175.9982     218.3127     201.6720     147.6410     145.2198     311.0000      40.7713     327.7379      -0.0107      -0.0475       2.9109      -0.0006       0.0277       4.9391    2728.2986    -100.3125    3760.0000
 1801.8252      93.7764     237.0583     132.7133      81.0498      79.8664     311.0000      39.2377     330.7427      -0.0075      -0.0442       5.5034      -0.0037       0.0241       4.9497    2722.8591     -99.0625    3642.0000
 1801.9776      94.3626     353.9606     117.6955      62.9607      61.9249     311.0000      41.1980     327.9200      -0.0101      -0.0468      17.0841       0.0030       0.0330       4.9066    2727.2983     -98.6250    3710.0000
 1802.1300      75.3596     239.7378     110.0583      71.1009      69.4356     311.0000      50.1095     328.2842      -0.0019      -0.0383      44.7691       0.0242       0.0586       4.7545    2713.2148     -95.8125    3754.0000
 1802.2824      79.1931     201.4828     196.7526      90.8559      87.6097     311.0000      69.4147     327.9200       0.0445       0.0098      75.2127       0.0799       0.1219       4.6760    2633.8450     -93.8750    3710.0000
 1802.4348      46.7542      65.8027      89.6437      65.6390      63.1381     311.0000      91.6931     328.2842       0.0219      -0.0137      98.7070       0.1408       0.1885       4.4616    2672.5349     -91.8750    3708.0000
 1802.5872      38.1782      33.3050      49.6037      93.1415      89.5565     311.0000      99.1955     329.6501       0.0057      -0.0305     108.1767       0.1135       0.1598       4.6590    2700.2615     -90.4375    3710.0000
 1802.7396      72.5921      28.2644      44.4697     119.1117     113.4891     311.0000      83.9425     331.5622       0.0051      -0.0311     115.0575       0.0729       0.1135       5.2880    2701.2346     -89.7500    3754.0000
 1802.8920     102.7778      79.9052      98.5894     195.3435     188.2320     311.0000      63.0692     331.0158      -0.0223      -0.0595     123.1241       0.0139       0.0460       5.6708    2748.2161     -89.9375    3689.0000
 1803.0444     140.0145     160.3766     208.8348     288.1354     276.4013     311.0000      47.9099     325.8258      -0.0293      -0.0667     124.8071      -0.0037       0.0242       5.4486    2760.0322     -89.3125    3646.0000
 1803.1968     132.5705     398.9002     902.2084     240.5618     229.5627     311.0000      45.5941     325.2795      -0.0201      -0.0572     118.3591      -0.0036       0.0237       5.3922    2744.3013     -89.3125    3732.0000
 1803.3492     103.9844     423.9692     365.8640     137.2104     131.5571     311.0000      44.0577     325.5527      -0.0191      -0.0562     108.7267       0.0083       0.0371       5.2481    2742.7317     -89.6250    3664.0000
 1803.5016      88.1071     252.9586     255.8199     112.5154     107.7480     311.0000      45.9348     326.8274      -0.0167      -0.0537      93.3101       0.0089       0.0379       5.0735    2738.5430     -90.0625    3648.0000
 1803.6540      99.6054     197.0518     188.0935     127.8002     121.4865     311.0000      44.2473     326.8274       0.0008      -0.0356      74.8708       0.0103       0.0394       4.9998    2708.7107     -89.8750    3681.0000
 1803.8064      84.2887     133.9020     169.9424     179.3343     166.1868     311.0000      43.6255     327.7379       0.0171      -0.0186      43.1876       0.0067       0.0357       4.8607    2680.7051     -90.6250    3739.0000
 1803.9588      84.4845     118.6305     216.3603     191.0706     173.6671     311.0000      41.7623     329.3769       0.0315      -0.0037      20.5257       0.0185       0.0485       4.8631    2656.1494     -90.3750    3761.0000
 1804.1112     100.4083     130.0460     286.3051     305.9196     279.0340     311.0000      49.4325     328.8306       0.0349      -0.0002       6.1350       0.0003       0.0292       4.9951    2650.3149     -90.3125    3732.0000
 1804.2636      66.7483      93.2033     180.7356     135.5517     130.6010     311.0000      52.9982     328.8306       0.0214      -0.0142      15.5106       0.0174       0.0475       4.7068    2673.4319     -90.2500    3670.0000
 1804.4160      61.5320      56.6023      70.6945      52.8044      50.9459     311.0000      52.5292     328.8306      -0.0026      -0.0391      42.5186       0.0162       0.0456       5.0943    2714.4443     -90.1250    3684.0000
 1804.5684      99.2614     122.0246     211.2505     123.3636     118.3299     311.0000      45.6339     329.5590      -0.0130      -0.0498      63.8599       0.0013       0.0291       5.0064    2732.1912     -89.9375    3766.0000
 1804.7208     159.9517     277.8351     293.3920     195.8748     187.0463     311.0000      42.5885     330.2874      -0.0217      -0.0588      71.8539      -0.0003       0.0275       5.0213    2747.0581     -89.3125    3690.0000
 1804.8732     109.1360     283.1568     256.1346     160.9027     152.8279     311.0000      43.1658     330.6516      -0.0210      -0.0581      64.6408       0.0074       0.0362       5.0069    2745.9287     -89.3125    3679.0000
 1805.0256      89.4587     183.7266     202.7905     107.1261     101.8435     311.0000      43.9628     330.4695      -0.0182      -0.0552      64.7941       0.0134       0.0428       5.1135    2741.1245     -89.3125    3682.0000
 1805.1780     122.6136     257.9738     459.4919     259.3401     243.6794     311.0000      44.5857     330.1053      -0.0248      -0.0621      63.6957       0.0034       0.0320       5.0144    2752.4473     -89.3125    3723.0000
 1805.3304     112.2469     224.1540     431.2391     381.4187     349.6354     311.0000      48.1381     330.8337      -0.0220      -0.0592      55.0928       0.0026       0.0308       4.6536    2747.6035     -89.3125    3695.0000
 1805.4828     106.8673     129.5047     277.1555     403.9513     337.7793     311.0000      45.7186     331.5622      -0.0026      -0.0391      35.3494       0.0070       0.0358       4.8606    2714.4675     -89.3125    3670.0000
 1805.6352     139.3826     234.5368     528.9950     693.7387     604.0938     311.0000      47.0593     332.1085      -0.0018      -0.0382      26.6638       0.0041       0.0327       4.9590    2713.0530     -88.0625    3657.0000
 1805.7876     119.8995     242.4723     534.2215     573.9240     501.6813     311.0000      47.1719     332.3816      -0.0012      -0.0376      26.2017       0.0014       0.0300       4.7483    2711.9993     -86.8750    3718.0000
 1805.9400     104.2440     181.6654     351.5425     339.9123     304.8643     311.0000      52.7795     332.6548       0.0063      -0.0298      28.1560       0.0159       0.0463       4.7349    2699.2288     -84.6875    3658.0000
 1806.0924      90.4611     158.6006     265.6075     215.7878     195.1063     311.0000      59.4570     332.1085       0.0086      -0.0275      19.8209       0.0109       0.0419       4.8013    2695.2971     -81.5000    3767.0000
 1806.2448      91.4516     128.6703     199.2675     163.5447     150.2294     311.0000      64.3157     333.3832       0.0137      -0.0222       8.9331       0.0201       0.0528       4.4058    2686.5857     -79.8750    3732.0000
 1806.3972      83.9564     113.2885     180.8584     145.9201     137.0613     311.0000      69.7609     333.9295       0.0106      -0.0253       5.9342       0.0331       0.0677       4.3540    2691.8149     -79.5625    3624.0000
 1806.5496      86.5519     124.2826     126.4586     136.9099     128.1494     311.0000      72.3871     333.7474       0.0009      -0.0355      26.7045       0.0415       0.0778       4.4615    2708.5037     -78.2500    3665.0000
 1806.7020      48.9560      73.5323      85.5177      96.1385      89.9218     311.0000      77.5576     334.2937      -0.0049      -0.0415      47.6766       0.0441       0.0819       4.4269    2718.4336     -73.3750    3710.0000
 1806.8544      49.8038      58.8661      63.1174      54.6581      52.9283     311.0000      82.7142     333.7474      -0.0078      -0.0445      66.4008       0.0550       0.0943       4.4042    2723.4075     -70.0000    3694.0000
 1807.0068      88.4055     110.0610     152.0585     131.4932     125.7556     311.0000      85.8734     333.0190      -0.0091      -0.0458      61.7304       0.0526       0.0923       4.5294    2725.5701     -69.7500    3689.0000
 1807.1592      68.8475      75.9524      99.1066      87.6970      84.8580     311.0000      85.8903     333.4742      -0.0170      -0.0539      58.2337       0.0678       0.1086       4.3449    2738.9949     -66.4375    3698.0000
 1807.3116      34.7602      36.5531      40.9703      30.3739      29.6297     311.0000      85.9052     333.9295      -0.0182      -0.0552      57.6561       0.0616       0.1023       4.2926    2741.1333     -63.4375    3706.0000
 1807.4640      51.8589      60.1348      53.9570      48.4471      47.0900     311.0000      85.9915     334.2937      -0.0183      -0.0553      55.4330       0.0719       0.1138       4.2316    2741.2253     -61.4375    3745.0000
 1807.6164      61.1391      77.1803      88.7307      83.8758      81.9532     311.0000      84.4549     334.8401      -0.0171      -0.0541      54.2316       0.0756       0.1178       4.2458    2739.2432     -60.0000    3728.0000
 1807.7688      80.3434      71.4461     103.0015      93.3940      90.6074     311.0000      81.5386     335.3864      -0.0122      -0.0490      51.3120       0.0642       0.1056       4.3189    2730.8665     -59.9375    3766.0000
 1807.9212      50.8964      59.6675      86.6395      83.8623      80.9979     311.0000      83.1613     334.2937      -0.0132      -0.0500      46.4735       0.0585       0.0998       4.2490    2732.5159     -57.8125    3812.0000
 1808.0736      55.1540      76.1317      83.6086      89.8075      85.9997     311.0000      81.9457     333.7474      -0.0170      -0.0540      41.6691       0.0819       0.1251       4.3456    2739.0671     -56.4375    3728.0000
 1808.2260      55.2277      74.7150     112.4114     131.7456     123.6671     311.0000      85.2798     334.2937      -0.0245      -0.0617      41.1341       0.0672       0.1093       4.1939    2751.8357     -55.5000    3702.0000
 1808.3784      61.4307      87.3877     130.5635     165.9311     154.4262     311.0000      81.4140     335.1132      -0.0275      -0.0649      46.3092       0.0572       0.0979       4.1956    2757.0933     -54.0000    3750.0000
 1808.5308      68.6206      85.1398     126.8530     139.4520     130.2912     311.0000      83.1613     335.3864      -0.0123      -0.0491      48.3387       0.0620       0.1029       4.4012    2730.9878     -53.0000    3743.0000
 1808.6832      58.1847     137.3660     190.3556     207.7626     200.2813     311.0000      84.7840     335.3864       0.0070      -0.0291      33.0744       0.0655       0.1061       4.2235    2698.0657     -52.0000    3702.0000
 1808.8356      84.9006     104.4854     122.3637     137.3543     130.5662     311.0000      85.1639     334.2937       0.0047      -0.0315      24.6084       0.0597       0.0992       4.3124    2702.0481     -51.5625    3631.0000
 1808.9880      42.3690      46.0982      59.2327      77.5397      74.4035     311.0000      76.2573     333.7474      -0.0099      -0.0466      33.1478       0.0386       0.0758       4.3253    2726.9363     -50.2500    3747.0000
 1809.1404      62.9258      58.4825      72.3772      88.3895      85.3656     311.0000      64.2303     334.8401      -0.0138      -0.0507      51.1088       0.0295       0.0656       4.8072    2733.6550     -50.6875    3735.0000
 1809.2928      57.5037      86.3934     111.5261     104.0137     101.7326     311.0000      61.6195     336.2058      -0.0144      -0.0513      46.3779       0.0325       0.0690       4.7304    2734.6938     -50.3750    3670.0000
 1809.4452      54.0125      88.5054     108.7505      95.0341      92.3789     311.0000      70.5852     337.5716       0.0065      -0.0296      25.4869       0.0585       0.0979       4.2199    2698.8489     -51.3125    3726.0000
 1809.5976      52.3562      78.4682     109.8135      77.8742      76.3979     311.0000      78.4423     338.1179       0.0163      -0.0195       6.5954       0.0676       0.1089       4.1718    2682.1563     -52.6250    3674.0000
 1809.7500      51.6641      69.3287      96.8892      73.9883      72.9809     311.0000      83.1031     340.3032       0.0181      -0.0177       3.7987       0.0841       0.1272       4.2238    2679.1304     -54.8750    3692.0000
 1809.9024      45.3069      54.2503      70.2002     100.3171      98.8681     311.0000      84.2870     336.7521       0.0076      -0.0285      15.7089       0.0755       0.1185       4.2760    2697.0420     -58.1250    3770.0000
 1810.0548      50.4682      57.6704      82.7868     114.8581     113.2691     311.0000      85.9405     334.5669      -0.0088      -0.0455      27.1854       0.0846       0.1285       4.2678    2725.0571     -60.0000    3757.0000
 1810.2072      52.5756      62.0731      95.3511     153.8326     151.9804     311.0000      83.9145     335.9327      -0.0060      -0.0426      33.6342       0.0747       0.1178       4.2347    2720.3071     -60.0000    3690.0000
 1810.3596      54.6667      62.4474      99.7168     155.9223     155.0671     311.0000      84.4967     341.9421      -0.0076      -0.0443      29.0473       0.0666       0.1090       4.1439    2723.0286     -61.3125    3698.0000
 1810.5120      57.9816      70.6471     114.7259     151.4072     151.5549     311.0000      84.7698     346.4948      -0.0050      -0.0415      30.9036       0.0760       0.1189       4.2953    2718.4846     -63.5000    3638.0000
 1810.6644      49.6080      57.8252      69.7531     100.0176     100.5362     311.0000      85.4989     341.6690      -0.0064      -0.0430      33.1209       0.0715       0.1139       4.2509    2721.0046     -66.3750    3734.0000
 1810.8168      40.6020      47.1112      51.1698      61.3646      61.9484     311.0000      82.1763     340.4853      -0.0038      -0.0403      23.9701       0.0672       0.1090       4.2556    2716.5576     -69.6875    3712.0000
 1810.9692      53.4699      75.9535      94.4670      79.2566      79.8508     311.0000      81.6870     339.7569       0.0055      -0.0307      11.0209       0.0630       0.1047       4.0869    2700.5779     -69.7500    3737.0000
 1811.1216      49.7733      75.1973      62.2733      56.1784      56.9877     311.0000      81.6070     342.1242       0.0158      -0.0199       5.2450       0.0750       0.1176       4.0419    2682.9148     -71.4375    3703.0000
 1811.2740      50.7832      87.2286      76.0599      53.9398      54.5068     311.0000      86.2478     338.1179       0.0148      -0.0210      25.3718       0.0732       0.1160       4.0921    2684.6931     -75.7500    3841.0000
 1811.4264      40.2000      73.9681      60.9444      53.7234      54.1318     311.0000      85.5187     342.4884       0.0201      -0.0155      46.7849       0.0755       0.1182       4.4610    2675.5837     -77.9375    3823.0000
 1811.5788      77.9271     123.8571      84.9738      97.7500      99.1545     311.0000      82.7060     336.4790       0.0039      -0.0323      64.5423       0.0668       0.1093       4.6602    2703.3330     -79.3125    3784.0000
 1811.7312      61.5807     124.5886      85.4978      89.5409      90.8042     311.0000      80.4493     334.4758       0.0105      -0.0255      62.7758       0.0880       0.1324       4.2803    2692.0771     -79.5625    3784.0000
 1811.8836      55.4193      63.9224      70.6375      79.1692      80.3843     311.0000      83.0456     337.9358       0.0245      -0.0110      58.5728       0.0998       0.1453       4.6586    2668.1375     -82.6250    3799.0000
 1812.0360      63.6937      39.9563      70.6021      80.2188      81.6303     311.0000      85.4137     343.3079       0.0095      -0.0266      40.0155       0.0870       0.1315       4.3684    2693.8201     -85.1250    3776.0000
 1812.1884      59.9761      52.4027      56.9897      83.5043      85.6631     311.0000      87.1531     342.1242       0.0132      -0.0227      20.9124       0.0684       0.1113       4.1884    2687.4895     -88.3750    3732.0000
 1812.3408      45.3731      41.7852      78.9756      94.2093      95.7570     311.0000      87.2230     335.5685       0.0319      -0.0033       6.8293       0.0909       0.1358       4.1174    2655.4927     -89.3125    3848.0000
 1812.4932      47.5934      63.4383      79.6582      73.1062      75.1862     311.0000      85.2876     336.2969       0.0573       0.0230      22.9640       0.0976       0.1431       4.2414    2611.9944     -90.4375    3766.0000
 1812.6456      40.9409      50.1531      57.4746      58.3096      59.4694     311.0000      83.2443     353.6879       0.1015       0.0688      44.1670       0.0988       0.1442       5.0720    2536.4329     -93.2500    3668.0000
 1812.7980      54.6640      48.3131      47.6487      44.1351      44.7975     311.0000      79.9290     351.9579       0.0644       0.0304      80.2088       0.0847       0.1290       4.6441    2599.8491     -98.0625    3732.0000
 1812.9504      46.0205      52.5521      50.1752      56.1192      57.5979     311.0000      80.8503     364.8874       0.0905       0.0574     122.9234       0.0830       0.1271       4.9452    2555.2490     -99.0625    3727.0000
 1813.1028      71.1373      77.8046     133.6488     100.1795     102.9789     311.0000      77.7325     361.6095       0.0824       0.0490     167.5889       0.0990       0.1445       5.6067    2569.1455    -101.5000    3731.0000
 1813.2552      50.9585     111.8425     139.7841     146.7739     153.2279     311.0000      77.7325     349.8637       0.0108      -0.0252     179.4784       0.0954       0.1410       5.4793    2691.5676    -103.7500    3713.0000
 1813.4076      66.5197      89.8010     151.2137     103.2482     110.0267     311.0000      73.6739     348.1337       0.0288      -0.0066     155.8368       0.1020       0.1484       4.8531    2660.8223    -107.7500    3702.0000
 1813.5600      69.6574      84.7874     135.1780     114.3643     120.3580     311.0000      73.7526     352.6863       0.0203      -0.0153     121.2020       0.1112       0.1581       4.7440    2675.2075    -110.0000    3790.0000
 1813.7124      61.7714      49.1915      58.4256      56.9490      59.2620     311.0000      71.6971     359.9705       0.0308      -0.0044     101.7330       0.0835       0.1282       4.9207    2657.2957    -113.9375    3732.0000
 1813.8648      73.0111      76.6464      92.3264      82.0657      86.7923     311.0000      73.4235     348.6800       0.0257      -0.0097      92.3445       0.0818       0.1258       4.7236    2665.9958    -118.6250    3747.0000
 1814.0172      99.1591     129.0652     181.8197     178.3289     184.2276     311.0000      74.0749     348.6800       0.0160      -0.0197      79.6244       0.0711       0.1135       4.5199    2682.5642    -119.6250    3761.0000
 1814.1696      56.3508      84.5844     108.5976     123.8233     128.0154     311.0000      79.5472     355.8731       0.0357       0.0006      65.1920       0.0711       0.1126       4.7442    2648.9570    -123.6250    3743.0000
 1814.3220      74.4831      61.3481      69.0157      89.4638      92.0358     311.0000      83.3381     355.9642       0.0699       0.0361      40.3559       0.0674       0.1082       4.3683    2590.4692    -127.6250    3695.0000
 1814.4744      71.8234      79.8864     102.9258      81.7216      84.6053     311.0000      77.3941     357.5121       0.0675       0.0336      23.3796       0.0530       0.0915       4.3833    2594.5435    -128.3750    3674.0000
 1814.6268      94.2591     150.7804     102.2425      80.4045      80.7377     311.0000      62.8654     351.9579       0.0547       0.0204      14.1377       0.0066       0.0392       4.7104    2616.3938    -134.6250    3730.0000
 1814.7792      64.4041     190.7433     100.6539      51.6834      53.0668     311.0000      58.7703     331.5622       0.0687       0.0349      34.3127       0.0029       0.0345       5.0392    2592.4946    -138.1250    3716.0000
 1814.9316      43.3251     150.0911      84.0980      47.9725      49.0920     311.0000      66.8758     339.3927       0.0506       0.0161      60.1571       0.0217       0.0551       4.7212    2623.4766    -141.6250    3714.0000
 1815.0840      86.0286     226.2455     156.0392      65.8175      67.4324     311.0000      79.3940     359.4242       0.1084       0.0760      78.1107       0.0621       0.1011       4.8483    2524.6726    -147.8750    3805.0000
 1815.2364      75.9572     134.4492     143.9027      94.4078      96.6332     311.0000      83.8823     343.0348       0.2502       0.2229      95.3381       0.1215       0.1674       5.5004    2282.1404    -151.5625    3775.0000
 1815.3888      62.1058      70.7691     118.3034     134.5023     139.7737     311.0000      83.4500     332.8369       0.1368       0.1054     124.0180       0.1276       0.1752       6.1008    2476.0969    -156.3125    3723.0000
 1815.5412     105.6863     104.3783     219.5453     381.8140     395.0970     311.0000      86.6490     344.4006       0.1083       0.0759     154.5041       0.0875       0.1321       5.7703    2524.7546    -159.2500    3811.0000
 1815.6936      99.4847     106.3868     219.4044     694.2838     709.2013     311.0000      84.2004     342.1242       0.0431       0.0083     161.1538       0.0812       0.1247       5.6719    2636.3823    -166.6250    3745.0000
 1815.8460      88.6968      85.1826     122.3461     785.4117     794.2579     311.0000      79.7916     349.8637       0.0362       0.0012     147.6228       0.0634       0.1038       5.3832    2648.0430    -170.2500    3778.0000
 1815.9984     234.2103     242.4959     282.9786     513.0596     517.5925     311.0000      65.9845     356.3284       0.0212      -0.0143     137.5918       0.0482       0.0845       5.6398    2673.6697    -177.1250    3777.0000
 1816.1508     372.0449     870.9898     528.5848     273.8254     276.8042     311.0000      57.8776     344.4916      -0.0326      -0.0702     135.5813      -0.0003       0.0291       5.7231    2765.7957    -179.4375    3695.0000
 1816.3032     323.6316     991.2927     309.8665     129.4379     130.0957     311.0000      50.0740     334.5669      -0.0127      -0.0495     141.0565      -0.0098       0.0166       5.5098    2731.7551    -186.5000    3703.0000
 1816.4556     150.9075     348.3435     181.2045     100.1081     100.8195     311.0000      47.0512     330.4695      -0.0172      -0.0541     142.5791      -0.0057       0.0196       5.6540    2739.3447    -190.5625    3704.0000
 1816.6080     183.4624     243.9748     139.7748      96.0245      96.4728     311.0000      43.2441     331.9264      -0.0427      -0.0806     140.4216      -0.0119       0.0122       5.9142    2783.0530    -196.7500    3720.0000
 1816.7604     251.2966     139.2931     204.6478     151.7152     152.4282     311.0000      40.4342     331.8353      -0.0343      -0.0719     126.2448      -0.0144       0.0094       5.6985    2768.6628    -200.5625    3741.0000
 1816.9128     273.4962     243.1295     322.1239     190.3067     190.9177     311.0000      40.0955     332.4727      -0.0225      -0.0597     105.5286      -0.0100       0.0142       5.6827    2748.5530    -205.8125    3763.0000
 1817.0652     138.9019     273.0823     249.7796     123.2189     123.4342     311.0000      39.7850     332.2906       0.0016      -0.0347      91.5484      -0.0098       0.0144       5.4980    2707.3071    -207.9375    3690.0000
 1817.2176     104.0654     102.6393     101.3747      65.4243      65.4662     311.0000      40.9738     332.1085      -0.0030      -0.0395      90.0040      -0.0089       0.0156       5.4333    2715.1094    -213.0000    3720.0000
 1817.3700     139.2516     245.6134     218.5955     105.8938     105.9902     311.0000      40.8160     329.6501       0.0241      -0.0114     101.0873      -0.0092       0.0154       5.4430    2668.7507    -216.2500    3698.0000
 1817.5224     114.4238     370.0339     326.8900     126.6889     126.7491     311.0000      41.6815     329.0127      -0.0049      -0.0414     117.8179      -0.0020       0.0231       5.7708    2718.2947    -221.8125    3721.0000
 1817.6748     126.7484     272.6959     383.3671     170.7629     170.7872     311.0000      41.3827     329.9232      -0.0064      -0.0430     125.3319      -0.0112       0.0128       5.7576    2720.9875    -226.0000    3713.0000
 1817.8272     165.5613     330.0948     910.2732     287.7095     286.7605     311.0000      40.5810     332.4727      -0.0150      -0.0519     121.6567      -0.0125       0.0116       5.6737    2735.6904    -227.8750    3699.0000
 1817.9796     181.8740     263.9700    1115.1729     491.9156     489.8452     311.0000      41.0138     332.1085      -0.0135      -0.0504     115.4022      -0.0062       0.0180       5.5476    2733.1667    -232.0000    3678.0000
 1818.1320     218.2939     229.8157    1366.1338     926.4971     913.4161     311.0000      43.7054     331.0158      -0.0213      -0.0584     117.5957      -0.0044       0.0202       5.5566    2746.3804    -235.8125    3702.0000
 1818.2844     231.5592     259.4548    1950.0000    1950.0000    1950.0000     311.0000      44.5819     329.9232      -0.0294      -0.0668     117.5096      -0.0074       0.0167       5.5933    2760.2952    -237.2500    3678.0000
 1818.4368     209.2630     305.8074    1802.7433    1367.3685    1287.6887     311.0000      43.5445     330.2874      -0.0285      -0.0659     108.0930      -0.0122       0.0118       5.4993    2758.8147    -240.0625    3701.0000
 1818.5892     158.3255     307.3884    1943.4866     783.6885     696.5063     311.0000      41.2597     332.1085      -0.0114      -0.0482      94.7883      -0.0130       0.0108       5.4869    2729.5344    -243.8750    3798.0000
 1818.7416     124.4480     268.8957    1304.4189    1113.7837    1036.2152     311.0000      41.7895     332.6548      -0.0159      -0.0529      87.6570      -0.0140       0.0094       5.3786    2737.2566    -245.5625    3738.0000
 1818.8940     116.5396     241.1769     883.1362     734.5971     676.5211     311.0000      40.2553     332.1085      -0.0059      -0.0425      88.4762      -0.0179       0.0053       5.3964    2720.1375    -245.5625    3785.0000
 1819.0464     122.7130     181.3207     642.8726     516.0364     466.3640     311.0000      40.8092     331.5622      -0.0101      -0.0468      89.3476      -0.0042       0.0198       5.3813    2727.2175    -246.8750    3760.0000
 1819.1988     148.7808     280.3467     300.7444     250.5989     229.2304     311.0000      41.1337     329.9232      -0.0173      -0.0543      87.4834      -0.0112       0.0129       5.3888    2739.6096    -248.6875    3816.0000
 1819.3512     169.3341     330.3042     503.8640     303.3389     264.4630     311.0000      44.2625     330.4695      -0.0123      -0.0491      87.4109      -0.0144       0.0094       5.3362    2731.0286    -249.3125    3859.0000
 1819.5036     198.2759     460.4555     855.3210     536.1139     480.2516     311.0000      45.8852     332.3816      -0.0165      -0.0535      87.4915      -0.0140       0.0096       5.4092    2738.2830    -251.0625    3789.0000
 1819.6560     164.3782     535.8467    1717.1418     895.9048     711.9622     311.0000      43.8297     333.2011      -0.0247      -0.0620      90.6363      -0.0142       0.0091       5.3500    2752.3157    -251.1250    3786.0000
 1819.8084     147.0001     349.5967     780.8693     710.7180     572.1597     311.0000      42.1075     333.4742      -0.0236      -0.0608      92.1130      -0.0127       0.0105       5.3490    2750.3477    -250.6875    3767.0000
 1819.9608     143.5067     321.3328     346.9008     350.3128     281.4000     311.0000      41.9835     332.1085      -0.0241      -0.0614      95.2208      -0.0078       0.0159       5.4207    2751.2393    -250.8125    3735.0000
 1820.1132     116.9976     256.8492     607.6611     679.4964     527.5621     311.0000      42.1999     331.0158      -0.0312      -0.0686      95.1686      -0.0088       0.0150       5.4357    2763.2725    -250.6875    3778.0000
 1820.2656     127.5966     285.5396     638.3293     594.7052     460.7603     311.0000      42.2692     331.0158      -0.0171      -0.0541      92.1917      -0.0117       0.0118       5.3869    2739.3130    -250.6250    3723.0000
 1820.4180     138.2766     381.2572    1181.7417    1041.8655     753.3222     311.0000      44.2832     333.0190      -0.0139      -0.0507      89.2041      -0.0137       0.0098       5.3500    2733.7087    -250.3750    3694.0000
 1820.5704     150.1982     418.3905    1461.2637    1404.0679    1192.7938     311.0000      47.0959     334.2937      -0.0138      -0.0506      91.8214      -0.0108       0.0127       5.4372    2733.5449    -250.1250    3712.0000
 1820.7228     147.1289     325.1053    1711.9940    1708.4384    1576.6534     311.0000      46.1148     333.4742      -0.0247      -0.0620      95.5789      -0.0124       0.0111       5.5136    2752.2769    -249.0625    3688.0000
 1820.8752     137.3912     249.4635    1507.5695    1614.2495    1383.7084     311.0000      44.5494     332.6548      -0.0285      -0.0659      93.2562      -0.0147       0.0088       5.4166    2758.7156    -248.0000    3742.0000
 1821.0276     128.4756     208.4431    1229.5463    1368.3011    1079.0470     311.0000      49.2012     331.2890      -0.0256      -0.0629      89.3071      -0.0153       0.0083       5.5338    2753.8054    -248.4375    3771.0000
 1821.1800     124.0719     196.4727     880.0162    1081.1825     783.6730     311.0000      52.4583     330.7427      -0.0225      -0.0596      84.6283      -0.0083       0.0154       5.4150    2748.3931    -248.3750    3677.0000
 1821.3324     122.7059     239.0714     793.5784     839.7916     615.7975     311.0000      55.7037     333.2011      -0.0181      -0.0551      85.7499      -0.0120       0.0112       5.3194    2740.9492    -247.6875    3687.0000
 1821.4848     134.5569     302.9916     716.9474     718.6941     528.4631     311.0000      49.4400     335.0222      -0.0289      -0.0663      84.8451      -0.0096       0.0134       5.4587    2759.3486    -246.5000    3730.0000
 1821.6372     124.8903     343.0881     479.4572     570.5757     450.8820     311.0000      46.3125     334.2937      -0.0137      -0.0506      83.2260      -0.0151       0.0080       5.2931    2733.4998    -246.9375    3734.0000
 1821.7896     114.3580     279.7682     531.4738     645.2086     499.3455     311.0000      41.9827     333.3832      -0.0184      -0.0555      84.0836      -0.0124       0.0106       5.5189    2741.5259    -246.0000    3726.0000
 1821.9420     123.6142     370.9443     622.7645     591.7813     489.9327     311.0000      41.7555     331.5622      -0.0262      -0.0636      84.3082      -0.0097       0.0136       5.4814    2754.8657    -245.5625    3702.0000
 1822.0944     103.6923     291.9463     467.7458     420.0669     365.3056     311.0000      42.1451     331.3800      -0.0241      -0.0614      84.5580      -0.0148       0.0081       5.5421    2751.2593    -245.5625    3713.0000
 1822.2468      85.5581     166.5667     279.0643     259.7273     239.3980     311.0000      42.1477     333.7474      -0.0312      -0.0687      83.2295      -0.0134       0.0095       5.5057    2763.3311    -245.5625    3701.0000
 1822.3992     154.7216     178.4343     538.7902     425.4030     375.9618     311.0000      42.5659     335.3864      -0.0272      -0.0645      84.8408      -0.0180       0.0044       5.4690    2756.4338    -245.5625    3695.0000
 1822.5516     146.1428     356.9048    1138.6713     801.5484     673.4868     311.0000      43.7966     335.2042      -0.0270      -0.0644      89.7384      -0.0164       0.0065       5.4881    2756.2173    -245.5625    3794.0000
 1822.7040     138.9006     359.0612     961.0453     671.4686     567.0797     311.0000      44.3226     334.5669      -0.0303      -0.0678      96.4236      -0.0112       0.0120       5.4873    2761.8469    -245.5625    3711.0000
 1822.8564     130.0539     314.6015     756.7053     562.0723     427.7159     311.0000      43.2553     331.5622      -0.0274      -0.0647     105.3789      -0.0045       0.0196       5.3896    2756.8237    -245.5625    3734.0000
 1823.0088     118.9442     219.9938     511.9629     461.0458     403.8665     311.0000      43.8499     331.0158      -0.0227      -0.0599     109.7572      -0.0050       0.0190       5.6055    2748.8713    -245.5625    3759.0000
 1823.1612      82.7734     103.4956     185.9910     190.7806     175.8127     311.0000      45.4875     333.7474      -0.0241      -0.0613     105.9556      -0.0123       0.0114       5.4894    2751.1941    -245.5625    3746.0000
 1823.3136     103.8635     121.4868     203.9706     223.8125     190.6053     311.0000      45.4875     334.2937      -0.0284      -0.0658      96.1359      -0.0129       0.0106       5.4537    2758.5706    -245.5625    3696.0000
 1823.4660     141.8179     231.6393     458.6986     404.0994     353.3361     311.0000      46.5874     335.3864      -0.0287      -0.0661      88.1007      -0.0089       0.0147       5.2472    2759.0791    -245.5625    3725.0000
 1823.6184     132.3811     292.4879     470.3840     288.0246     258.2433     311.0000      47.2365     335.3864      -0.0356      -0.0732      78.7761      -0.0156       0.0074       5.2222    2770.8574    -245.1875    3705.0000
 1823.7708     112.0573     269.7049     356.9728     240.2633     215.9260     311.0000      50.0493     333.4742      -0.0432      -0.0811      66.4759      -0.0132       0.0099       5.2607    2783.7878    -245.5000    3708.0000
 1823.9232     118.6275     529.5888     409.3063     337.1805     277.9042     311.0000      48.7323     332.1085      -0.0429      -0.0808      56.1161      -0.0112       0.0119       5.1498    2783.3210    -244.6250    3689.0000
 1824.0756     153.5227     521.0079     715.8762     479.0200     413.7378     311.0000      46.0277     334.2937      -0.0344      -0.0720      42.8214      -0.0135       0.0091       5.1974    2768.7979    -244.5625    3715.0000
 1824.2280     176.9732     754.0298    1950.0000    1950.0000    1737.9929     311.0000      41.4659     336.6611      -0.0188      -0.0558      27.5455      -0.0142       0.0082       5.2507    2742.1396    -245.2500    3713.0000
 1824.3804     175.9666     485.9052    1092.3440    1263.2950    1132.2393     311.0000      34.8077     337.2074      -0.0062      -0.0427      10.3836      -0.0169       0.0047       5.2281    2720.5366    -244.1250    3664.0000
 1824.5328     130.7839     267.4668     576.2472     811.2553     681.6683     311.0000      29.4375     336.7521      -0.0102      -0.0470       1.4970      -0.0224      -0.0014       5.2593    2727.5017    -243.0625    3672.0000
 1824.6852     134.7604     170.2615     327.0406     611.5673     489.8773     311.0000      25.4530     334.6579      -0.0043      -0.0409      11.5459      -0.0206       0.0003       5.3129    2717.4177    -242.7500    3720.0000
 1824.8376     102.6663     138.4633     248.2540     312.7700     253.6195     311.0000      25.5262     333.3832      -0.0201      -0.0572      50.3094      -0.0230      -0.0019       5.4706    2744.4153    -242.8125    3712.0000
 1824.9900     106.7429     303.5204     509.7969     493.3210     420.0688     311.0000      33.4928     334.2937      -0.0356      -0.0732     116.0834      -0.0249      -0.0036       5.4109    2770.8538    -242.1250    3717.0000
 1825.1424     101.6361     318.7541     762.7987     550.7379     425.6577     311.0000      46.1501     331.9264       0.0101      -0.0259     180.8121      -0.0109       0.0121       4.9872    2692.8081    -241.4375    3744.0000
 1825.2948     109.3378     374.7753     969.8611     662.6812     508.1768     311.0000      52.8506     331.5622       0.0001      -0.0362     216.6104       0.0007       0.0258       5.7139    2709.8052    -241.6875    3701.0000
 1825.4472     110.2990     261.8979     946.1333     659.7512     457.4534     311.0000      48.5233     330.4695       0.0013      -0.0351     210.6998       0.0059       0.0326       6.5153    2707.8496    -240.7500    3721.0000
 1825.5996     114.8841     223.5475     884.6658    1274.2119     992.2099     311.0000      39.7382     328.4664      -0.0026      -0.0391     183.3248      -0.0014       0.0252       6.0950    2714.4773    -240.7500    3734.0000
 1825.7520     124.6910     238.9992    1124.3153    1614.2518    1351.4752     311.0000      35.7856     327.9200      -0.0129      -0.0497     145.7124      -0.0076       0.0183       5.6990    2731.9790    -241.1875    3694.0000
 1825.9044     118.2306     245.7177    1148.3197    1854.7743    1669.6761     311.0000      33.5561     331.9264      -0.0183      -0.0553     120.8029      -0.0118       0.0134       5.7007    2741.2449    -242.0000    3754.0000
 1826.0568     121.9066     305.5614    1429.5326    1793.9771    1610.9011     311.0000      31.4149     333.9295      -0.0305      -0.0679     109.4151       0.0004       0.0256       5.6143    2762.0835    -241.1875    3696.0000
 1826.2092     121.2001     337.4782    1950.0000    1950.0000    1838.3561     311.0000      31.4128     335.0222      -0.0307      -0.0682     110.1139      -0.0096       0.0147       5.4056    2762.5332    -241.0000    3676.0000
 1826.3616     124.1319     313.7601    1221.7435    1196.1809     889.3954     311.0000      31.6951     334.8401      -0.0302      -0.0677     117.5973      -0.0110       0.0130       5.3416    2761.6448    -241.3750    3719.0000
 1826.5140     135.9631     282.1623     833.7800     812.9807     662.8537     311.0000      35.6615     329.7411      -0.0219      -0.0591     128.7737      -0.0109       0.0133       5.4142    2747.4883    -241.0625    3678.0000
 1826.6664     145.1448     264.2194     558.8505     587.5140     479.1793     311.0000      38.3861     326.9185      -0.0345      -0.0722     142.9560      -0.0110       0.0135       5.6287    2769.0752    -241.4375    3701.0000
 1826.8188     111.2150     194.3015     310.9503     324.8962     275.3272     311.0000      39.1434     328.1022      -0.0387      -0.0764     151.7825      -0.0005       0.0244       5.6741    2776.1179    -241.3750    3708.0000
 1826.9712     103.7759     270.7857     183.5299     223.9928     203.0261     311.0000      39.9680     331.0158      -0.0222      -0.0594     149.7240      -0.0081       0.0166       5.4797    2747.9658    -241.3750    3733.0000
 1827.1236     110.2957     199.4831     429.4676     319.2840     274.7894     311.0000      38.3149     332.1085      -0.0255      -0.0628     139.1742      -0.0076       0.0171       5.5719    2753.5522    -241.5625    3706.0000
 1827.2760     142.7072     362.1591     898.0507     593.0668     549.1074     311.0000      38.6394     330.8337      -0.0203      -0.0574     127.6085      -0.0121       0.0121       5.4376    2744.7417    -241.0625    3705.0000
 1827.4284     130.6946     282.1014     770.8302     511.7310     469.2371     311.0000      39.0316     328.0111      -0.0177      -0.0547     114.9456      -0.0120       0.0120       5.5590    2740.2351    -241.3125    3704.0000
 1827.5808     123.9484     204.3076     439.2658     221.7720     212.7706     311.0000      39.0639     326.0990      -0.0161      -0.0530     104.8191      -0.0068       0.0175       5.3893    2737.4827    -241.0000    3687.0000
 1827.7332     112.6569     170.2119     366.1509     386.3072     358.3228     311.0000      40.1457     327.0095      -0.0148      -0.0517      99.7000      -0.0018       0.0231       5.5509    2735.3726    -240.1250    3653.0000
 1827.8856     100.1088     141.4161     270.2641     416.0065     384.4568     311.0000      40.3716     329.9232      -0.0139      -0.0507     102.5209      -0.0130       0.0111       5.4010    2733.7217    -240.0625    3656.0000
 1828.0380     106.6798     180.0578     355.0176     366.1964     315.7937     311.0000      42.0056     332.1085      -0.0207      -0.0578     108.7639      -0.0047       0.0201       5.3115    2745.3906    -239.2500    3711.0000
 1828.1904     112.1248     289.1906     585.2732     627.1559     569.9277     311.0000      41.7893     332.1085      -0.0263      -0.0636     113.0135      -0.0006       0.0244       5.3576    2755.0020    -240.3125    3685.0000
 1828.3428     141.9899     325.5971     649.0350     598.5295     538.4016     311.0000      39.4340     328.8306      -0.0288      -0.0662     115.7153      -0.0103       0.0144       5.2656    2759.1687    -239.4375    3673.0000
 1828.4952     104.8459     185.9112     258.1357     214.5574     189.0096     311.0000      39.6192     326.3722      -0.0361      -0.0738     112.8235      -0.0074       0.0176       5.2882    2771.8103    -239.6250    3658.0000
 1828.6476     125.0752     186.8131     284.1449     281.6158     246.0608     311.0000      39.2822     326.9185      -0.0306      -0.0681     105.2709       0.0010       0.0267       5.4395    2762.3936    -239.0000    3687.0000
 1828.8000     135.8248     475.0387     535.8348     507.7113     456.9955     311.0000      39.6878     329.9232      -0.0297      -0.0672      93.7798      -0.0053       0.0200       5.3076    2760.8240    -239.7500    3731.0000
 1828.9524     170.4680     426.4933     645.8809     597.3040     549.5320     311.0000      36.8751     332.4727      -0.0275      -0.0649      82.3622      -0.0057       0.0198       5.2130    2757.0281    -239.2500    3692.0000
 1829.1048     134.6469     372.9416     294.0270     448.8524     362.9532     311.0000      36.6148     332.3816      -0.0283      -0.0656      72.1316      -0.0055       0.0199       5.2527    2758.3083    -238.8750    3711.0000
 1829.2572     132.8818     273.4344     357.9370     167.2094     153.5304     311.0000      41.6837     330.1053      -0.0221      -0.0593      62.7367      -0.0042       0.0211       5.1476    2747.8022    -237.9375    3702.0000
 1829.4096     197.1249     424.5352     633.7693     393.2423     359.4803     311.0000      45.1455     327.1916      -0.0159      -0.0529      64.0280      -0.0012       0.0240       5.1184    2737.2161    -237.5625    3611.0000
 1829.5620     187.4458     353.1142     467.6000     308.4556     287.4939     311.0000      45.6525     326.8274      -0.0132      -0.0501      80.3494      -0.0149       0.0091       5.3347    2732.6487    -236.5000    3697.0000
 1829.7144     137.8176     151.1890     187.4641     180.2680     174.0238     311.0000      41.1920     327.7379      -0.0152      -0.0521     110.6255      -0.0094       0.0151       5.2040    2736.0120    -235.8125    3751.0000
 1829.8668     121.0727     235.0950     403.4358     310.6588     290.1376     311.0000      39.0284     328.8306      -0.0369      -0.0746     146.6322      -0.0044       0.0204       5.4740    2773.0938    -235.8125    3751.0000
 1830.0192     143.9942     319.8923     656.3073     668.8625     585.5476     311.0000      38.3614     327.9200      -0.0356      -0.0733     169.7297      -0.0064       0.0186       5.6447    2770.8838    -235.8125    3721.0000
 1830.1716     130.9617     175.7410     316.4802     407.3828     366.9740     311.0000      39.1617     324.7332      -0.0370      -0.0747     168.0601      -0.0017       0.0234       5.8319    2773.2939    -235.8125    3689.0000
 1830.3240     141.3717     127.8646     173.0580     251.7292     226.6442     311.0000      38.4518     323.0032      -0.0294      -0.0669     141.7856      -0.0137       0.0108       5.5141    2760.3135    -235.8125    3647.0000
 1830.4764     139.1296     123.6144     132.7579     248.7667     222.3523     311.0000      37.6945     322.0927      -0.0238      -0.0610     109.6208      -0.0043       0.0208       5.3142    2750.6458    -235.1250    3687.0000
 1830.6288     144.1580     236.0882     319.3093     199.2910     181.9299     311.0000      36.6127     325.0064      -0.0239      -0.0612      90.0059      -0.0128       0.0117       5.3518    2750.9121    -234.0625    3688.0000
 1830.7812     153.7524     302.3490     343.6379     226.7216     216.4137     311.0000      36.9919     327.7379      -0.0263      -0.0636      84.2314      -0.0118       0.0127       5.2101    2755.0132    -232.7500    3687.0000
 1830.9336     127.8473     146.5646     202.8067      94.6594      90.1294     311.0000      40.8498     327.7379      -0.0381      -0.0759      83.7386       0.0021       0.0275       5.1734    2775.2227    -233.0000    3694.0000
 1831.0860      66.2560      76.3595     100.4232     130.1539     123.8684     311.0000      40.9513     326.6453      -0.0516      -0.0899      79.1793       0.0008       0.0266       5.0254    2798.2563    -232.5625    3632.0000
 1831.2384     123.8550     135.5983     236.3275     232.8824     222.2553     311.0000      40.4820     328.8306      -0.0451      -0.0831      72.6521      -0.0061       0.0194       5.0505    2787.1543    -230.8125    3673.0000
 1831.3908     208.2175     299.5563     452.0295     462.3571     430.0255     311.0000      37.1650     321.5464      -0.0439      -0.0818      65.0330      -0.0109       0.0143       4.9610    2785.0117    -229.2500    3722.0000
 1831.5432     167.3289     505.1778    1312.1154     914.3282     781.4097     311.0000      36.8379     324.4601      -0.0402      -0.0780      73.7364      -0.0097       0.0151       4.8522    2778.7524    -227.6875    3720.0000
 1831.6956     163.1866     763.1451    1636.4768     485.9521     435.4805     311.0000      36.8747     325.1885      -0.0295      -0.0670      96.9992      -0.0035       0.0214       4.9809    2760.4866    -226.0000    3737.0000
 1831.8480     157.5674     872.4599    1506.5458     510.0481     439.5487     311.0000      36.9469     325.0064      -0.0462      -0.0842     125.5927      -0.0048       0.0202       4.9657    2788.9438    -226.0000    3692.0000
 1832.0004     145.5095     610.1433    1120.4827     448.9513     428.5146     311.0000      35.5439     323.3674      -0.0350      -0.0726     142.8399      -0.0093       0.0149       5.1317    2769.7917    -226.0000    3698.0000
 1832.1528     133.9798     300.4527     518.3433     449.1331     379.6941     311.0000      33.4944     318.4506      -0.0421      -0.0800     143.7781      -0.0101       0.0144       5.4244    2782.0686    -225.4375    3657.0000
 1832.3052     112.0173     182.4762     262.5747     364.9420     303.7612     311.0000      35.3197     317.3580      -0.0351      -0.0728     141.5851      -0.0083       0.0163       4.9667    2770.0518    -223.6875    3689.0000
 1832.4576     142.6135     263.0577     421.7141     643.9807     502.5374     311.0000      34.0221     319.8164      -0.0281      -0.0655     138.6533      -0.0061       0.0189       5.0290    2758.0649    -221.7500    3734.0000
 1832.6100     145.5121     369.1264     705.7568     922.8392     737.3296     311.0000      35.9334     322.0927      -0.0529      -0.0912     136.8160      -0.0093       0.0152       5.1269    2800.4941    -220.0000    3729.0000
 1832.7624     168.9432     507.3026    1950.0000    1950.0000    1487.1298     311.0000      32.7378     322.8211      -0.0465      -0.0845     130.3921      -0.0082       0.0164       5.0751    2789.5066    -218.6250    3698.0000
 1832.9148     161.5273     448.7927    1950.0000    1073.0118     724.0233     311.0000      31.4403     321.7285      -0.0442      -0.0821     115.6161      -0.0005       0.0246       5.0078    2785.5129    -217.6875    3665.0000
 1833.0672     152.7315     358.4557    1323.7738    1368.3937    1070.6306     311.0000      32.0172     319.1790      -0.0441      -0.0820     104.4464      -0.0044       0.0208       4.8171    2785.3569    -216.2500    3644.0000
 1833.2196     147.3094     326.2801     825.9623     824.3811     558.0789     311.0000      35.2064     316.9937      -0.0563      -0.0947      95.9780      -0.0072       0.0176       4.7877    2806.2893    -216.2500    3679.0000
 1833.3720     151.9919     272.3878     777.4102     809.0348     690.0314     311.0000      38.6727     318.9969      -0.0415      -0.0794      95.5222      -0.0129       0.0117       4.5982    2780.9790    -213.5625    3759.0000
 1833.5244     142.5093     230.3693     527.1602     501.7190     455.7448     311.0000      38.6665     321.7285      -0.0313      -0.0688      88.3167      -0.0034       0.0218       4.6368    2763.5811    -211.9375    3678.0000
 1833.6768     136.5154     256.9735     812.0767     781.4251     682.9169     311.0000      38.6146     323.0943      -0.0464      -0.0845      89.7152      -0.0104       0.0148       4.6969    2789.3762    -210.4375    3708.0000
 1833.8292     152.2462     460.2390    1405.1221    1394.8889    1135.2086     311.0000      36.2057     322.8211      -0.0453      -0.0833      94.1856      -0.0016       0.0242       4.4729    2787.4316    -209.0000    3708.0000
 1833.9816     134.0721     433.4935     884.9261    1047.5223     869.1496     311.0000      36.9626     321.4553      -0.0610      -0.0996      96.5385      -0.0046       0.0212       4.6101    2814.3855    -207.1875    3690.0000
 1834.1340     135.6759     325.8965     707.6710     952.1759     760.3368     311.0000      33.7171     318.0864      -0.0712      -0.1101      86.2870       0.0011       0.0274       4.3665    2831.6997    -206.5000    3717.0000
 1834.2864     134.2587     289.7521     687.8766     894.5245     735.7471     311.0000      35.6873     319.5432      -0.0552      -0.0935      78.1217      -0.0021       0.0242       4.1799    2804.3120    -206.5000    3717.0000
 1834.4388     137.9911     320.3358     775.0557     756.2893     574.9367     311.0000      32.5345     322.0016      -0.0505      -0.0887      80.9331      -0.0042       0.0220       4.6051    2796.3164    -204.5000    3747.0000
 1834.5912     136.4256     352.5230     899.1158     733.0585     606.5435     311.0000      32.5293     323.0032      -0.0533      -0.0916      88.2146      -0.0051       0.0214       4.5461    2801.0786    -202.6250    3718.0000
 1834.7436     112.4177     226.9321     501.0008     312.9763     291.1988     311.0000      33.1844     323.0943      -0.0388      -0.0766      89.9212      -0.0019       0.0250       4.8906    2776.4106    -200.8750    3688.0000
 1834.8960     126.4760     368.9135    1209.3666     961.9227     845.0449     311.0000      36.1250     321.9106      -0.0620      -0.1006      87.0452       0.0023       0.0295       4.6254    2815.9719    -199.1250    3689.0000
 1835.0484     132.5602     378.6728    1121.1855    1086.6235     992.8082     311.0000      37.0982     318.7238      -0.0636      -0.1023      89.4718       0.0028       0.0297       4.1280    2818.7832    -196.7500    3726.0000
 1835.2008     119.9674     281.3409     767.2205     804.1581     704.6870     311.0000      35.0427     319.5432      -0.0530      -0.0913      92.4261      -0.0020       0.0245       4.4515    2800.6101    -196.7500    3674.0000
 1835.3532     107.5962     204.5111     521.0002     549.8360     461.9359     311.0000      34.1301     323.0032      -0.0499      -0.0881      89.7679       0.0017       0.0286       4.4120    2795.3987    -194.8750    3763.0000
 1835.5056     120.3479     256.9063     690.4577     714.7571     556.7583     311.0000      35.9683     325.2795      -0.0549      -0.0933      81.2116      -0.0020       0.0251       4.6743    2803.8760    -192.6875    3726.0000
 1835.6580     128.2827     367.1993    1319.0476    1196.8844     952.3152     311.0000      36.5092     325.3706      -0.0628      -0.1015      62.5927       0.0003       0.0280       4.2711    2817.4587    -190.5625    3690.0000
 1835.8104     124.8239     459.5042    1120.9192    1097.9491     976.1146     311.0000      36.0981     324.4601      -0.0613      -0.0999      50.6127       0.0068       0.0353       4.0114    2814.8044    -187.5625    3693.0000
 1835.9628     127.2214     431.1938    1623.9357    1535.5739    1281.9644     311.0000      35.6720     321.9106      -0.0597      -0.0982      56.0198       0.0013       0.0298       3.9888    2812.0757    -186.9375    3677.0000
 1836.1152     123.3187     294.1538     522.1695     541.7874     459.1891     311.0000      37.7208     321.3643      -0.0840      -0.1234      68.4021       0.0081       0.0371       4.0695    2853.5579    -185.5000    3708.0000
 1836.2676     105.5489     145.5537     227.6632     248.1749     208.6785     311.0000      38.6389     323.0943      -0.1006      -0.1406      85.2418       0.0112       0.0402       3.9392    2881.9551    -183.0000    3721.0000
 1836.4200     109.1483     193.2536     323.9504     464.5161     341.2492     311.0000      38.2062     326.0990      -0.1039      -0.1441      85.9337       0.0058       0.0342       3.9291    2887.7493    -180.5625    3688.0000
 1836.5724     148.5212     385.4470     658.3940     756.4174     595.7089     311.0000      36.4761     326.6453      -0.1056      -0.1459      83.8900       0.0062       0.0341       3.8338    2890.6528    -178.3750    3736.0000
 1836.7248     148.0300     374.6649    1182.0229    1137.0573     844.3839     311.0000      35.6649     327.1916      -0.0940      -0.1338      70.9300       0.0008       0.0282       3.8605    2870.7024    -177.1875    3706.0000
 1836.8772     120.3962     239.6905     624.3410     558.4717     464.4781     311.0000      34.7995     324.4601      -0.0916      -0.1313      55.9721      -0.0014       0.0259       3.8719    2866.6433    -176.3125    3678.0000
 1837.0296     110.5555     187.9574     390.0349     375.1611     290.6267     311.0000      38.8002     324.8242      -0.0985      -0.1385      49.0797      -0.0030       0.0249       3.9278    2878.4658    -173.3750    3697.0000
 1837.1820     123.1663     182.6963     335.5453     368.7750     293.0450     311.0000      40.5240     327.4648      -0.0987      -0.1387      57.3912       0.0099       0.0400       3.7506    2878.8337    -170.3125    3720.0000
 1837.3344      88.1886     204.5062     182.8469     362.3794     275.1811     311.0000      41.0589     330.8337      -0.0941      -0.1339      79.0441       0.0288       0.0620       3.6645    2870.9351    -168.1875    3754.0000
 1837.4868      80.9882     143.5702     224.0508     167.7858     136.5917     311.0000      32.9922     332.9279      -0.0822      -0.1216     103.3168       0.0312       0.0653       3.6417    2850.5891    -167.4375    3745.0000
 1837.6392     108.5562     207.6741     476.5869     402.1205     328.5035     311.0000      25.9968     333.5653      -0.0806      -0.1199     111.1214       0.0261       0.0600       3.6758    2847.7983    -166.7500    3774.0000
 1837.7916     111.6845     178.6364     322.4729     530.3990     383.2415     311.0000      20.6871     332.3816      -0.0789      -0.1182     100.7514       0.0315       0.0661       3.8909    2844.9958    -164.9375    3766.0000
 1837.9440      79.3450     113.7195     188.4868     353.0912     249.7176     311.0000      21.8336     334.2937      -0.0715      -0.1104      76.9875       0.0338       0.0691       3.5261    2832.1838    -162.9375    3730.0000
 1838.0964      86.8356     118.4110     144.0301     685.1389     485.9965     311.0000      22.0352     339.2105      -0.0626      -0.1013      51.5091       0.0317       0.0670       3.4070    2817.1011    -160.3125    3775.0000
 1838.2488      73.6668     119.2184     219.5063     758.1483     501.5402     311.0000      22.0466     341.1227      -0.0421      -0.0800      29.4385       0.0304       0.0656       3.4614    2782.0068    -158.4375    3743.0000
 1838.4012      75.9758     135.7223     307.7552     711.5820     461.1157     311.0000      19.1763     340.3032      -0.0424      -0.0803      13.5763       0.0354       0.0711       3.5515    2782.5007    -157.6875    3743.0000
 1838.5536      81.5965     165.5157     351.1788     571.8955     361.2852     311.0000      19.4074     340.4853      -0.0490      -0.0871       9.0678       0.0344       0.0703       3.5332    2793.7263    -157.5625    3722.0000
 1838.7060      67.6688     109.7825     271.0694     436.9813     316.1062     311.0000      20.1058     339.4837      -0.0565      -0.0949      26.1838       0.0367       0.0728       3.6856    2806.6152    -155.2500    3646.0000
 1838.8584      69.2367      88.1158     225.1330     392.4780     271.0372     311.0000      21.2180     341.1227      -0.0836      -0.1230      50.7343       0.0458       0.0821       3.4932    2852.9641    -152.2500    3697.0000
 1839.0108      69.0445      90.6607     260.9052     464.6685     365.9822     311.0000      20.8934     343.0348      -0.0889      -0.1285      81.6562       0.0402       0.0752       3.7321    2861.9785    -149.1875    3793.0000
 1839.1632      80.0753      81.1996     212.1288     354.8698     297.4499     311.0000      20.8934     343.7632      -0.0943      -0.1341     104.1496       0.0191       0.0519       3.8102    2871.2861    -147.8750    3826.0000
 1839.3156      64.3890      78.8639     136.6759     202.8759     175.1549     311.0000      26.4737     345.2200      -0.0877      -0.1273     138.7427       0.0245       0.0574       3.8948    2860.0198    -147.8750    3770.0000
 1839.4680      56.1005      70.5254      78.9541      91.2646      84.6719     311.0000      40.2026     344.1274      -0.0930      -0.1327     179.1208       0.0135       0.0455       4.4955    2868.9526    -147.8125    3753.0000
 1839.6204      34.9972      50.4899      59.3586      71.7866      63.5306     311.0000      46.6923     340.8495      -0.1007      -0.1407     207.2916       0.0264       0.0596       4.8143    2882.1133    -146.0000    3708.0000
 1839.7728      35.1288      65.6954      85.1222      93.1453      84.1420     311.0000      43.1433     341.3958      -0.1345      -0.1757     208.8697       0.0196       0.0517       4.9026    2939.9426    -144.3750    3685.0000
 1839.9252      36.0823      36.0609      40.7212      41.8966      39.9322     311.0000      29.7355     343.0348      -0.1381      -0.1795     183.7325       0.0063       0.0368       5.2697    2946.1365    -142.6250    3732.0000
 1840.0776      12.9163      17.0108      19.6621      20.6044      20.1900     311.0000      22.4346     345.4932      -0.1246      -0.1655     153.8258       0.0172       0.0483       4.6520    2923.0579    -142.1250    3744.0000
 1840.2300      28.8708      21.5872      38.7350      40.0545      38.4848     311.0000      19.5694     348.1337      -0.1012      -0.1412     139.9021       0.0202       0.0520       4.5570    2882.9939    -142.2500    3746.0000
 1840.3824      32.0522      43.6847      63.4432      68.2835      64.4169     311.0000      18.5278     349.8637      -0.0889      -0.1285     136.6487       0.0189       0.0507       4.0456    2861.9629    -142.1875    3749.0000
 1840.5348      38.3386      48.1128     108.9514     139.6829     123.1970     311.0000      18.7521     350.6832      -0.0931      -0.1328     134.7661       0.0151       0.0457       3.8347    2869.1797    -142.3125    3718.0000
 1840.6872      60.2915      82.3047     206.5754     282.9649     206.8524     311.0000      21.5159     350.6832      -0.0834      -0.1228     121.6080       0.0082       0.0375       3.9461    2852.5747    -142.5625    3743.0000
 1840.8396      64.1770     147.8211     397.3194     469.8300     290.8493     311.0000      22.1270     352.0490      -0.0803      -0.1196     113.8420       0.0066       0.0351       3.8000    2847.2776    -143.3750    3755.0000
 1840.9920      71.9398     243.2450     775.0118     727.5038     474.6965     311.0000      21.6969     357.4211      -0.0719      -0.1108     115.4420       0.0059       0.0341       3.6449    2832.8687    -144.0000    3772.0000
 1841.1444      69.2592     281.7266     599.4225     444.8145     302.5585     311.0000      19.1495     359.0600      -0.0892      -0.1288     116.0700      -0.0029       0.0248       3.8856    2862.5964    -144.7500    3766.0000
 1841.2968      56.7156     141.2371     412.9374     271.8313     191.2464     311.0000      20.2649     358.8779      -0.0945      -0.1343      99.3810       0.0037       0.0321       3.8003    2871.5947    -145.2500    3763.0000
 1841.4492      57.0607     129.5698     422.7632     274.6227     181.5918     311.0000      20.0429     359.1511      -0.0688      -0.1077      78.9583       0.0072       0.0361       3.6599    2827.6936    -146.0625    3759.0000
 1841.6016      62.9880     144.4969     676.1494     321.4154     202.6023     311.0000      21.5763     353.5969      -0.0513      -0.0895      45.3215       0.0068       0.0362       3.4382    2797.7468    -147.0625    3743.0000
 1841.7540      65.1138     131.2435     758.6769     506.4963     327.3272     311.0000      21.1112     357.5121      -0.0323      -0.0698      24.9498       0.0127       0.0428       3.4643    2765.2061    -147.8750    3721.0000
 1841.9064      60.9559     112.9664     664.9701     681.3849     436.6943     311.0000      22.0427     356.6926      -0.0308      -0.0682       7.0548       0.0138       0.0442       3.3918    2762.5955    -147.8750    3798.0000
 1842.0588      61.3269      98.7843     496.0140     699.6039     475.0428     311.0000      20.5216     360.6989      -0.0486      -0.0867      36.7901       0.0206       0.0514       3.5512    2793.0764    -148.5625    3752.0000
 1842.2112      65.5324     105.3741     400.1216     508.7930     367.8563     311.0000      19.2629     360.7900      -0.0816      -0.1209      73.1356       0.0092       0.0391       3.5456    2849.5200    -150.8125    3738.0000
 1842.3636      57.0288     115.1027     315.6476     342.6248     259.5933     311.0000      17.6854     360.5168      -0.0977      -0.1377     102.4661       0.0087       0.0383       3.5982    2877.1245    -151.1875    3690.0000
 1842.5160      66.7974     121.8541     242.2279     227.2121     182.2870     311.0000      17.9865     358.6958      -0.1071      -0.1474      98.3751       0.0122       0.0423       3.5605    2893.1650    -153.3750    3708.0000
 1842.6684      60.7618     147.2496     301.6324     233.7851     168.4463     311.0000      19.1020     391.9299      -0.0987      -0.1387      86.4816       0.0108       0.0400       3.5022    2878.8135    -155.9375    3762.0000
 1842.8208      71.3006     198.0065     621.5537     365.2560     287.7093     311.0000      21.0884     356.8747      -0.0863      -0.1258      66.9816       0.0116       0.0416       3.4302    2857.6025    -157.6875    3737.0000
 1842.9732      75.9324     202.8145     841.3273     354.0999     289.6671     311.0000      24.7776     357.0569      -0.0786      -0.1179      48.0790       0.0073       0.0367       3.4613    2844.4626    -158.2500    3734.0000
 1843.1256      77.5156     156.6913     886.4487     542.7271     406.8111     311.0000      35.4165     355.7821      -0.0689      -0.1077      52.8827       0.0111       0.0407       3.5679    2827.7751    -161.1250    3789.0000
 1843.2780      73.5108     120.7185     571.0732     574.1294     431.1122     311.0000      46.8446     354.5074      -0.0835      -0.1229      61.6121       0.0109       0.0408       3.7155    2852.7300    -163.1875    3781.0000
 1843.4304      60.7502      95.0732     353.8736     453.3468     332.8646     311.0000      56.2392     353.4147      -0.0927      -0.1325      76.9269       0.0157       0.0462       3.8892    2868.5825    -165.1250    3752.0000
 1843.5828      61.4958      86.0211     197.3385     287.1938     209.4854     311.0000      51.0383     348.6800      -0.0874      -0.1269      47.8132       0.0242       0.0553       4.0058    2859.3848    -166.8125    3769.0000
 1843.7352      66.6316     140.7924     234.5048     239.6445     177.3250     311.0000      44.2747     347.9516      -0.0763      -0.1154      28.7473       0.0162       0.0461       3.4716    2840.4834    -167.4375    3761.0000
 1843.8876      88.0932     262.6350     213.2427     256.6723     188.6690     311.0000      40.0728     347.7695      -0.0621      -0.1007       9.0353      -0.0009       0.0274       3.4811    2816.2219    -167.4375    3752.0000
 1844.0400      87.2308     604.8578     540.7544     251.0896     186.0698     311.0000      46.0845     348.7711      -0.0653      -0.1040      16.8281      -0.0002       0.0284       3.5183    2821.6260    -167.4375    3812.0000
 1844.1924     115.0046     660.0748     523.1811     299.3588     218.4418     311.0000      47.7636     347.7695      -0.0649      -0.1037      45.0895       0.0100       0.0399       3.5761    2821.0417    -167.4375    3786.0000
 1844.3448     102.2621     307.2822     279.3002     183.0198     147.5074     311.0000      41.9268     346.3127      -0.0816      -0.1209      88.5594       0.0157       0.0463       3.7220    2849.4573    -167.4375    3745.0000
 1844.4972      81.1882     118.6605     142.3345     122.1614     113.7084     311.0000      30.5087     346.6768      -0.0776      -0.1168     131.6533       0.0066       0.0362       3.9609    2842.7104    -167.4375    3746.0000
 1844.6496     129.0294     251.2055     446.7820     341.9108     284.1828     311.0000      27.5114     347.9516      -0.1150      -0.1555     137.5165       0.0060       0.0355       4.4502    2906.6174    -167.4375    3801.0000
 1844.8020     127.1790     223.0756     673.9599     632.4750     530.5447     311.0000      33.8996     347.9516      -0.1082      -0.1485     108.7203       0.0070       0.0373       3.6906    2895.0635    -167.4375    3827.0000
 1844.9544     124.3267     204.2998     637.2083     746.7532     630.9346     311.0000      36.4947     346.6768      -0.0812      -0.1205      56.9730       0.0232       0.0555       3.6387    2848.8169    -167.4375    3753.0000
 1845.1068     114.7268     196.3880     468.3950     435.9504     375.3607     311.0000      32.8929     345.5842      -0.0665      -0.1053      21.6107       0.0267       0.0598       3.3647    2823.7866    -166.5000    3792.0000
 1845.2592     159.3851     272.6925     282.5129     212.7543     192.1554     311.0000      22.1698     344.1274      -0.0524      -0.0907       2.3146       0.0179       0.0505       3.3348    2799.5952    -165.4375    3845.0000
 1845.4116      92.0019     169.0934     171.9931     141.0839     124.4710     311.0000      19.8473     343.3990      -0.0522      -0.0904       2.8696       0.0183       0.0515       3.2493    2799.2334    -164.8125    3845.0000
 1845.5640      52.2499      85.4195      67.8012      54.5636      52.5425     311.0000      19.3064     344.8558      -0.0520      -0.0902      30.6802       0.0244       0.0581       3.3374    2798.8821    -163.6250    3885.0000
 1845.7164      75.7510     227.4512     161.9783      87.0583      79.9456     311.0000      19.8471     345.7664      -0.0584      -0.0969      65.9683       0.0304       0.0647       3.5039    2809.9346    -162.8125    3877.0000
 1845.8688      94.6106     545.3819     399.8274     241.4011     215.4452     311.0000      20.0499     349.9547      -0.0656      -0.1044      98.6173       0.0307       0.0644       3.5547    2822.2520    -161.9375    3834.0000
 1846.0212     123.5674     556.3400     940.3832     586.9910     556.0245     311.0000      24.7017     350.4100      -0.0694      -0.1082     113.2216       0.0351       0.0692       3.6245    2828.5972    -161.3125    3835.0000
 1846.1736     187.6676     292.7122     753.5884     874.6156     805.9386     311.0000      29.7076     347.4053      -0.0846      -0.1240     117.1880       0.0266       0.0597       4.4142    2854.6431    -160.0625    3817.0000
 1846.3260     193.2103     222.1695     701.4014    1292.3102    1218.0925     311.0000      37.6739     341.3958      -0.1081      -0.1483     109.3774       0.0178       0.0503       3.8022    2894.7683    -158.8750    3830.0000
 1846.4784     148.9703     287.3987     871.9997     855.8472     804.9563     311.0000      51.6652     341.5779      -0.1035      -0.1437      89.4208       0.0095       0.0407       3.4682    2887.0393    -157.6875    3855.0000
 1846.6308     110.9711     261.2040     749.7614     458.6092     419.9757     311.0000      65.1490     353.7790      -0.0880      -0.1276      70.6265       0.0144       0.0462       3.4816    2860.5117    -157.6875    3867.0000
 1846.7832      96.7636     285.6940     582.2867     266.5589     237.1338     311.0000      74.7252     335.9327      -0.0891      -0.1287      59.2570       0.0342       0.0685       3.6763    2862.4282    -157.6875    3799.0000
 1846.9356      83.0192     171.0198     250.8335     147.0191     135.8225     311.0000      65.0612     335.3864      -0.0749      -0.1140      46.2282       0.0383       0.0735       3.5979    2838.1274    -157.1875    3795.0000
 1847.0880      91.6242     248.8795     476.7766     348.1548     280.1566     311.0000      49.0583     334.4758      -0.0654      -0.1042      30.0248       0.0201       0.0533       3.5182    2821.9150    -154.7500    3993.0000
 1847.2404     105.4152     208.4580     582.6271     280.2612     216.2656     311.0000      31.5849     328.2842      -0.0539      -0.0922      15.9543       0.0136       0.0455       3.4898    2802.1965    -154.1875    3942.0000
 1847.3928     143.3740     105.7106     178.4965     231.8417     204.6767     311.0000      23.8042     328.8306      -0.0508      -0.0890      15.0523       0.0179       0.0499       3.4441    2796.8069    -153.6250    3804.0000
 1847.5452      86.1588      57.9836      82.5726     177.0656     160.8926     311.0000      21.2119     329.9232      -0.0387      -0.0765      13.7200       0.0177       0.0500       3.4196    2776.1863    -152.1250    3767.0000
 1847.6976      53.5266      73.0332      71.1034     237.7059     209.1344     311.0000      19.4191     331.0158      -0.0440      -0.0819      12.2201       0.0220       0.0551       3.4492    2785.2112    -150.4375    3800.0000
 1847.8500      77.7582      87.7109     128.7056     146.0478     129.7914     311.0000      17.8930     330.2874      -0.0366      -0.0743       3.1536       0.0269       0.0608       3.3470    2772.6016    -148.8750    3807.0000
 1848.0024     131.8711     184.7414     257.1282     266.8546     233.8967     311.0000      18.2435     327.7379      -0.0392      -0.0769       2.3813       0.0357       0.0702       3.4001    2776.9587    -147.8750    3787.0000
 1848.1548     183.7605     315.5112     269.8741     128.4222     119.1727     311.0000      18.0891     327.7379      -0.0631      -0.1018      12.5129       0.0279       0.0614       3.3773    2817.9329    -147.8750    3833.0000
 1848.3072     117.6704     201.2996     163.6457     115.9560     109.0778     311.0000      17.7647     329.0127      -0.0784      -0.1176      37.7371       0.0208       0.0535       3.4619    2843.9817    -147.7500    3804.0000
 1848.4596      65.1440     107.7389     111.1142     122.9649     116.1226     311.0000      20.6597     329.9232      -0.0718      -0.1108      47.8070       0.0200       0.0525       3.4606    2832.7412    -146.0625    3761.0000
 1848.6120      79.8471     109.2667     213.2228     200.5798     187.6162     311.0000      23.3452     332.4727      -0.0555      -0.0938      38.7950       0.0248       0.0577       3.5727    2804.8459    -143.6875    3763.0000
 1848.7644      95.0610     156.4773     306.4707     337.2939     306.7521     311.0000      27.4592     332.1085      -0.0573      -0.0957      14.2176       0.0231       0.0559       3.4946    2807.9297    -142.0000    3757.0000
 1848.9168     113.0591     164.1327     315.4262     376.1861     325.1061     311.0000      27.9104     330.8337      -0.0601      -0.0986       5.4846       0.0175       0.0499       3.4493    2812.7346    -139.3125    3838.0000
 1849.0692      88.9631      87.8520     151.1572     169.0720     151.6838     311.0000      27.3846     330.1964      -0.0547      -0.0931       3.8900       0.0219       0.0544       3.4667    2803.6008    -138.1250    3798.0000
 1849.2216      83.3212      89.1400     152.1469     263.1171     215.7869     311.0000      25.0046     330.2874      -0.0438      -0.0818       2.4796       0.0125       0.0442       3.4397    2784.8972    -138.1250    3802.0000
 1849.3740      98.4865     228.2786     323.5315     390.1076     330.7305     311.0000      23.1794     332.1085      -0.0567      -0.0951      17.1227       0.0173       0.0494       3.4422    2806.9734    -137.6250    3850.0000
 1849.5264      96.7009     330.9249     532.6332     435.3892     356.0602     311.0000      21.7737     333.7474      -0.0716      -0.1106      35.6584       0.0276       0.0601       3.4453    2832.4348    -135.1875    3838.0000
 1849.6788      98.4674     298.7086     748.7653     496.7040     377.7029     311.0000      20.1701     334.2937      -0.0817      -0.1210      60.6563       0.0144       0.0461       3.4121    2849.7229    -132.9375    3834.0000
 1849.8312     105.7868     314.2476     899.1895     545.2521     399.7061     311.0000      20.1340     332.4727      -0.0929      -0.1326      66.9868       0.0232       0.0558       3.5267    2868.8516    -131.6250    3818.0000
 1849.9836     105.0235     307.7110    1129.4962     688.4401     566.5520     311.0000      24.7058     332.1085      -0.0882      -0.1278      68.9247       0.0203       0.0536       3.5402    2860.8232    -131.1875    3720.0000
 1850.1360     101.6174     231.5000     901.2559     860.7087     613.4785     311.0000      34.6393     333.3832      -0.0922      -0.1320      54.3296       0.0214       0.0551       3.5475    2867.7231    -129.6250    3696.0000
 1850.2884      99.8672     183.5229     621.0349     948.3242     595.8440     311.0000      40.5864     335.9327      -0.0842      -0.1237      43.5314       0.0366       0.0718       3.5176    2854.0349    -128.3750    3729.0000
 1850.4408      96.9389     188.4413     564.8550    1063.6365     683.8353     311.0000      35.8014     337.5716      -0.0798      -0.1191      41.0554       0.0349       0.0701       3.4087    2846.5332    -127.4375    3808.0000
 1850.5932      99.4308     188.6315     696.0860     911.8639     567.2194     311.0000      27.4675     337.5716      -0.0731      -0.1122      44.9963       0.0370       0.0726       3.4866    2835.0513    -126.4375    3786.0000
 1850.7456     100.8207     203.5407     651.6029     668.4528     384.4700     311.0000      21.0496     336.2969      -0.0632      -0.1019      36.9322       0.0374       0.0732       3.3889    2818.0796    -125.7500    3696.0000
 1850.8980     111.4719     260.3647     767.0093     658.4686     389.5512     311.0000      21.9116     336.4790      -0.0582      -0.0967      22.2793       0.0364       0.0728       3.3897    2809.5154    -124.2500    3739.0000
 1851.0504     111.3386     267.4188     629.9502     685.2552     492.8061     311.0000      21.6301     336.4790      -0.0483      -0.0864      19.9759       0.0453       0.0827       3.4218    2792.5332    -122.4375    3769.0000
 1851.2028      79.5641     131.9605     268.5473     308.0757     221.7236     311.0000      20.9147     337.5716      -0.0497      -0.0879      32.1064       0.0376       0.0745       3.4719    2794.9648    -120.8750    3765.0000
 1851.3552      97.2868     181.1733     438.9125     550.8448     399.7709     311.0000      21.6716     339.2105      -0.0457      -0.0837      43.1011       0.0437       0.0806       3.5164    2788.1331    -119.7500    3792.0000
 1851.5076     112.4128     211.2092     513.2778     570.0179     424.0670     311.0000      20.9618     339.2105      -0.0414      -0.0793      45.4881       0.0322       0.0684       3.4896    2780.7781    -118.6250    3770.0000
 1851.6600     109.4407     129.2360     355.3298     354.9813     282.7635     311.0000      20.7454     336.1148      -0.0131      -0.0499      30.4646       0.0557       0.0936       3.4947    2732.3223    -118.6250    3783.0000
 1851.8124      97.0538     155.7717     211.8267     208.7948     173.8586     311.0000      20.6373     336.4790      -0.0034      -0.0399      17.6930       0.0435       0.0810       3.3499    2715.8469    -117.3750    3772.0000
 1851.9648      83.5922     128.9920     190.6852     202.8128     163.3089     311.0000      20.0289     336.6611      -0.0084      -0.0451       6.0341       0.0403       0.0778       3.2886    2724.4495    -115.9375    3761.0000
 1852.1172      76.3952     133.3746     189.7368     186.5526     153.0596     311.0000      20.1494     337.8448      -0.0174      -0.0544       9.6099       0.0391       0.0768       3.3551    2739.7720    -114.5000    3727.0000
 1852.2696      82.3648     145.6762     302.0545     293.1879     219.5910     311.0000      19.0682     340.1211      -0.0204      -0.0576      24.2841       0.0423       0.0805       3.4042    2744.9624    -113.6250    3750.0000
 1852.4220     102.3029     203.1373     432.8541     433.4986     322.4531     311.0000      18.5081     340.3032      -0.0232      -0.0604      45.9318       0.0561       0.0956       3.4530    2749.6001    -111.1875    3775.0000
 1852.5744      84.5559     137.9343     324.5392     433.8972     308.7989     311.0000      17.4114     339.9390      -0.0198      -0.0569      55.0983       0.0572       0.0974       3.3692    2743.9312    -109.6250    3798.0000
 1852.7268      89.1377     112.7662     225.1950     376.3007     243.9812     311.0000      17.6095     338.6642      -0.0134      -0.0503      55.1457       0.0615       0.1021       3.5165    2732.9583    -108.8125    3777.0000
 1852.8792      81.0636      90.5806     158.3109     364.4418     239.3732     311.0000      19.3404     339.2105      -0.0539      -0.0922      42.9313       0.0638       0.1046       3.4214    2802.0869    -108.8125    3735.0000
 1853.0316      70.6170      72.1295     118.0559     261.2116     188.8070     311.0000      21.4477     344.1274      -0.0359      -0.0735      43.3083       0.0606       0.1004       3.2795    2771.3101    -107.2500    3830.0000
 1853.1840      83.0730     119.0454     226.2733     472.8564     319.9404     311.0000      21.0366     353.2326      -0.0421      -0.0800      34.5483       0.0387       0.0763       3.4139    2782.0332    -106.6875    3792.0000
 1853.3364      78.0359     226.5623     361.6560     616.5236     400.8939     311.0000      20.7085     349.8637      -0.0468      -0.0849      22.6798       0.0439       0.0816       3.3295    2790.0867    -104.8125    3710.0000
 1853.4888      99.1704     234.9199     402.0123     575.2019     348.7505     311.0000      19.0365     349.0442      -0.0319      -0.0694       7.1318       0.0425       0.0800       3.3371    2764.5352    -103.0625    3706.0000
 1853.6412      87.1225     151.8755     303.3429     448.5053     272.5199     311.0000      19.2448     347.5874      -0.0562      -0.0946       2.2473       0.0426       0.0793       3.3354    2806.0249    -101.4375    3663.0000
 1853.7936      76.1390     115.4421     206.6241     224.5987     151.3464     311.0000      17.7310     347.6784      -0.0831      -0.1225      43.1662       0.0409       0.0769       3.3676    2852.1750     -99.0625    3737.0000
 1853.9460      78.8236     121.2489     241.2194     444.3425     276.9231     311.0000      19.9135     351.0474      -0.0920      -0.1318     108.9437       0.0229       0.0572       3.4116    2867.3958     -98.3750    3865.0000
 1854.0984      71.4586     118.4320     246.5164     609.3846     345.5327     311.0000      19.8133     353.9611      -0.1137      -0.1542     184.2229       0.0192       0.0530       3.9469    2904.4590     -96.2500    3806.0000
 1854.2508      70.4850     117.1288     349.4459     940.1318     526.3854     311.0000      20.4814     355.4179      -0.1305      -0.1716     209.8815       0.0358       0.0708       4.5704    2933.1570     -94.1875    3815.0000
 1854.4032      76.0533     141.3227     428.5528    1273.7856     749.6214     311.0000      19.9217     354.6895      -0.1438      -0.1854     190.4509       0.0363       0.0713       4.4020    2955.9744     -92.0000    3777.0000
 1854.5556      71.3349     109.9876     297.3823    1272.6527     688.3054     311.0000      20.2428     350.4100      -0.1235      -0.1644     145.2529       0.0365       0.0719       3.8252    2921.2278     -89.5625    3733.0000
 1854.7080      65.3858      71.1229     174.2207    1226.9988     551.3320     311.0000      22.4765     351.2295      -0.1024      -0.1425     101.3095       0.0410       0.0766       3.4801    2885.1509     -89.3125    3816.0000
 1854.8604      56.9284      70.6800     184.4589    1143.3429     648.7473     311.0000      22.5847     351.2295      -0.0894      -0.1290      77.0078       0.0350       0.0698       3.4338    2862.7925     -85.8125    3848.0000
 1855.0128      49.7940      67.9834     158.1431     716.4733     455.6419     311.0000      22.8010     352.5953      -0.0691      -0.1079      55.8734       0.0174       0.0504       3.5310    2828.0955     -82.7500    3860.0000
 1855.1652      50.6301      84.4472     192.2634     371.1167     270.0612     311.0000      21.0919     353.4147      -0.0636      -0.1023      35.5377       0.0219       0.0550       3.4974    2818.8003     -80.6250    3814.0000
 1855.3176      51.5809     109.2238     185.9564     222.9867     195.1230     311.0000      21.6412     352.3221      -0.0441      -0.0821      14.0390       0.0227       0.0556       3.5228    2785.4084     -79.5625    3804.0000
 1855.4700      36.4115      60.8604     107.7336     119.8997     103.4443     311.0000      22.2938     351.2295      -0.0450      -0.0830       2.6512       0.0207       0.0530       3.5876    2786.8987     -77.3125    3785.0000
 1855.6224      44.9273      85.0525     168.0030     193.3545     158.0408     311.0000      22.7860     352.3221      -0.0497      -0.0879      -1.3640       0.0125       0.0441       3.4942    2794.9602     -73.6875    3816.0000
 1855.7748      45.1399     119.3672     239.1783     309.3089     249.9836     311.0000      22.6656     353.7790      -0.0336      -0.0711      -1.4203       0.0178       0.0497       3.7547    2767.3782     -70.0000    3800.0000
 1855.9272      49.0694     101.5507     261.1960     491.1522     376.7738     311.0000      23.0983     355.9642      -0.0623      -0.1010      19.3787       0.0203       0.0521       4.7129    2816.5845     -69.7500    3825.0000
 1856.0796      39.6575      62.0574     213.1923     646.4033     421.4527     311.0000      22.6027     358.8779      -0.1128      -0.1533      37.1735       0.0125       0.0436       4.2469    2902.9282     -66.1875    3824.0000
 1856.2320      32.9363      44.8368     138.8491     747.3865     491.6933     311.0000      21.1044     359.9705      -0.1196      -0.1603      40.0555       0.0177       0.0488       3.8509    2914.5417     -62.0625    3820.0000
 1856.3844      35.5255      48.2745     106.6108     833.5229     623.3617     311.0000      20.5959     359.6974      -0.0928      -0.1325      17.5664       0.0119       0.0424       3.5659    2868.6938     -60.0000    3835.0000
 1856.5368      35.4551      54.8068     209.7205     627.1352     538.9973     311.0000      23.6235     357.0569      -0.0691      -0.1079       0.5331       0.0157       0.0460       3.8462    2828.1094     -55.6875    3845.0000
 1856.6892      45.4621      75.3052     231.5089     359.1338     330.0182     311.0000      26.0993     356.9658      -0.0797      -0.1190      -2.3568       0.0035       0.0327       3.8609    2846.3704     -50.5625    3858.0000
 1856.8416      47.5034      92.0781     160.8261     176.9088     163.6285     311.0000      26.4035     358.3316      -0.0759      -0.1150       1.0026       0.0083       0.0375       3.5654    2839.8269     -49.0000    3922.0000
 1856.9940      30.1777      46.1947      59.8405      55.9525      52.0211     311.0000      26.7279     360.7900      -0.0740      -0.1131       1.4155       0.0160       0.0457       3.6395    2836.6150     -44.1250    3882.0000
 1857.1464      39.2279     110.7689     108.2734      88.7939      83.4419     311.0000      24.2521     361.4274      -0.0697      -0.1086       0.3185       0.0088       0.0376       3.6715    2829.1545     -40.5000    3863.0000
 1857.2988      42.4089     237.2663     183.4097     115.9469     109.0838     311.0000      23.9155     362.3379      -0.0716      -0.1106      -1.6279       0.0032       0.0303       4.1289    2832.4724     -38.8125    3784.0000
 1857.4512      51.2653     212.1279     227.6119     103.6874      98.0411     311.0000      21.8666     359.6063      -0.0665      -0.1053      -3.5558      -0.0108       0.0140       4.1022    2823.6858     -32.5625    3843.0000
 1857.6036      38.6125     148.1037     116.3836      83.6246      80.6560     311.0000      25.7488     358.3316      -0.0504      -0.0886      -3.5307      -0.0160       0.0077       4.6413    2796.2480     -29.1250    3878.0000
 1857.7560      81.1815     116.6653     132.7022      99.2092      96.7513     311.0000      26.1775     360.8810      -0.0266      -0.0640      -2.7282      -0.0019       0.0222       5.3082    2755.5549     -24.1250    3877.0000
 1857.9084     177.0557     104.3213     117.0615     126.7743     124.6449     311.0000      28.0065     366.5263      -0.0217      -0.0589       9.6805      -0.0063       0.0168       5.2447    2747.1123     -20.9375    3823.0000
 1858.0608     122.1512      50.0031      42.1513      48.8293      49.0166     311.0000      25.9510     370.1684      -0.0180      -0.0550      19.6316      -0.0203       0.0027       5.5175    2740.7905     -19.4375    3783.0000
 1858.2132      46.1640      31.1073      21.9383      26.3724      26.5621     311.0000      27.5827     370.3505      -0.0484      -0.0866      38.9645      -0.0393      -0.0147       5.7277    2792.8364     -13.7500    3760.0000
 1858.3656      25.0538      22.0672      18.5391      32.3917      32.6318     311.0000      32.0196     368.7115      -0.0559      -0.0943      52.9990       0.0558       0.0936       5.5612    2805.6399      -5.0625    3912.0000
 1858.5180      38.9723      37.5611      28.4962      23.9302      24.0932     311.0000      48.6796     367.0726      -0.0046      -0.0411      81.9383       0.1977       0.2461       5.5083    2717.8015       0.1875    3984.0000
 1858.6704      15.4326      64.9446      28.3177      17.7836      17.7794     311.0000      67.1215     368.9847       0.1261       0.0943     131.2160       0.0697       0.1100       5.9455    2494.3821       2.3125    3875.0000
 1858.8228      23.4298      42.7713      21.5070      13.1480      13.1240     311.0000      84.4858     390.0178       0.0624       0.0283     176.8923       0.0825       0.1261       5.9829    2603.2566       4.0000    3844.0000
 1858.9752      33.1527      29.5732      17.1464      10.2719      10.2572     311.0000      90.3276     401.3084       0.0664       0.0324     206.1024       0.1435       0.1933       5.7543    2596.4658       7.1250    3874.0000
 1859.1276      45.3399      36.0763      26.4464      21.3563      21.2774     311.0000      98.1486     417.3336       0.0875       0.0543     198.4608       0.1764       0.2276       5.3559    2560.3425       8.3750    3892.0000
 1859.2800      60.2186      41.4321      43.5791      38.7973      38.4310     311.0000     103.0586     434.2693       0.1093       0.0769     190.7964       0.2003       0.2519       5.4565    2523.0693       8.3750    3854.0000
 1859.4324      31.6567      24.2741      34.9917      60.9815      59.4424     311.0000     107.6294     460.6746       0.1624       0.1319     194.4795       0.2453       0.2977       5.7104    2432.3801       8.7500    3776.0000
 1859.5848      46.9209      27.1128      53.5223      67.0679      64.2258     311.0000     106.1084     415.4214       0.1650       0.1346     185.8785       0.2525       0.3038       6.1038    2427.9258      10.3125    3849.0000
 1859.7372      33.8070      30.8903      42.9895      48.5947      46.8780     311.0000     104.1621     448.6556       0.1661       0.1358     163.8982       0.2199       0.2713       6.1104    2425.9805      10.3125    3878.0000
 1859.8896      49.6107      24.4473      27.9899      31.5881      30.6463     311.0000     102.4383     476.0625       0.2284       0.2004     137.8913       0.2444       0.2961       6.0827    2319.3533      10.0000    3871.0000
 1860.0420      39.3765      16.8374      17.1335      35.9745      33.9383     311.0000     100.6259     499.2808       0.1921       0.1627     132.4894       0.2334       0.2853       6.2858    2381.5017      10.3125    3833.0000
 1860.1944      58.4163      43.4457      44.7284      52.3841      49.4134     311.0000     102.8166     501.1019       0.1562       0.1255     158.4747       0.1852       0.2365       6.1153    2442.9382      10.5000    3788.0000
 1860.3468      30.5999      30.4989      27.9286      27.8516      26.9047     311.0000     101.2677     477.7014       0.1431       0.1120     189.5540       0.1427       0.1925       6.1494    2465.2629      11.2500    3793.0000
 1860.4992      11.1865      10.1454      10.2018      10.7761      10.5840     311.0000     106.2235     482.7093       0.1074       0.0750     215.5223       0.1780       0.2294       6.2446    2526.2617      10.6250    3873.0000
 1860.6516      23.9694      17.7245      17.3396      17.8372      17.1726     311.0000     104.5735     417.8799       0.0677       0.0338     214.7920       0.1868       0.2381       6.1912    2594.2612       9.6250    3874.0000
 1860.8040      20.3209      19.2762      15.0713      18.7890      17.9929     311.0000     107.2378     492.5429       0.0760       0.0424     204.8945       0.2155       0.2677       5.7317    2580.0298       9.5625    3863.0000
 1860.9564      19.5568      20.3295      31.9570      23.7193      22.3770     311.0000     107.0420     497.0956       0.0984       0.0656     186.0719       0.1964       0.2481       5.6772    2541.7712      10.1250    3818.0000
 1861.1088      19.1904      21.4924      32.7003      30.2195      28.5870     311.0000     108.3879     469.2335       0.1260       0.0942     163.3711       0.1971       0.2486       6.0659    2494.5078      10.0000    3761.0000
 1861.2612      17.9072      15.6274      21.1613      20.4557      19.1969     311.0000     109.7061     451.4783       0.1590       0.1285     167.4602       0.2224       0.2743       6.5035    2438.0300       8.3750    3864.0000
 1861.4136      28.9932      22.4451      35.3450      20.7862      20.2227     311.0000     107.3261     510.5714       0.1849       0.1552     199.4703       0.2192       0.2712       6.2660    2393.8882       4.7500    3936.0000
 1861.5660      44.3784      30.2233      45.5271      44.2869      42.1280     311.0000     103.1858     527.6892       0.1463       0.1152     241.5555       0.1677       0.2186       6.5750    2459.8733       1.9375    3893.0000
 1861.7184      54.6438      44.0081      52.2900      69.6596      64.0183     311.0000     101.5662     535.1555       0.1427       0.1115     243.5963       0.1573       0.2078       6.8073    2465.9546       1.1250    3832.0000
 1861.8708      29.2291      22.2439      31.8122      65.0092      55.6241     311.0000     100.8971     544.8071       0.1888       0.1593     189.2402       0.1503       0.2005       6.0184    2387.1133      -1.3125    3819.0000
 1862.0232      28.6150      38.4738      56.6757      48.8182      45.4479     311.0000     102.2860     398.5768       0.2230       0.1947     162.9324       0.1641       0.2148       6.4571    2328.7471      -1.4375    3857.0000
 1862.1756      28.3501      29.7992      42.0525      32.6054      30.4319     311.0000     103.0943     400.6710       0.2158       0.1873     151.9864       0.1832       0.2346       6.6774    2341.0154      -4.3125    3879.0000
 1862.3280      27.9727      29.9710      19.1102      17.7479      16.9514     311.0000      99.0034     441.1894       0.1447       0.1136     180.4585       0.1719       0.2228       6.4367    2462.4915      -7.0625    3880.0000
 1862.4804      27.0911      23.2446      26.2585      26.4626      25.4843     311.0000     100.7580     438.9130       0.1659       0.1356     189.0969       0.2099       0.2616       6.3633    2426.3030      -8.8125    3847.0000
 1862.6328      35.3380      26.0599      25.6979      17.7870      16.7779     311.0000      97.7871     476.1535       0.2160       0.1875     192.8554       0.2237       0.2762       6.3072    2340.6287      -9.4375    3772.0000
 1862.7852      43.9328      21.6292      36.6800      47.7565      44.6608     311.0000     101.7766     476.0625       0.2782       0.2520     205.3266       0.1897       0.2412       6.9625    2234.2532     -11.1875    3831.0000
 1862.9376      32.5999      20.4418      22.6547      41.4362      38.2860     311.0000      99.3733     441.3714       0.2413       0.2137     206.9359       0.1854       0.2368       6.7997    2297.3713     -11.1875    3839.0000
 1863.0900      24.1448      18.3891      22.7242      30.0095      28.8637     311.0000     101.5330     451.7514       0.2404       0.2128     217.5987       0.1982       0.2501       6.6213    2298.8499     -11.1875    3729.0000
 1863.2424      29.5300      27.1822      23.9710      15.6169      15.2289     311.0000     105.8932     437.5472       0.2463       0.2189     216.1531       0.1926       0.2441       6.7669    2288.8945     -11.1875    3770.0000
 1863.3948      23.6487      24.9867      22.0544      14.0019      13.6690     311.0000     110.1218     460.8567       0.1804       0.1506     202.2736       0.2171       0.2692       6.4030    2401.5247     -11.1875    3710.0000
 1863.5472      28.2773      29.2238      15.4152      10.8486      10.5893     311.0000     108.7190     454.2098       0.0779       0.0444     162.4987       0.2113       0.2635       6.2453    2576.8115     -12.1250    3739.0000
 1863.6996      25.2335      25.3661      15.7676      13.4734      12.5917     311.0000     101.9251     496.9135       0.0465       0.0119     141.3286       0.1157       0.1640       5.3017    2630.4023     -14.0000    3743.0000
 1863.8520      16.2626      26.0928      23.6948      17.5073      16.6790     311.0000     102.5812     475.7893       0.1442       0.1131     130.2965       0.1109       0.1589       5.7086    2463.3875     -13.2500    3686.0000
 1864.0044      19.2702      18.8289      37.8572      27.8275      25.2950     311.0000     109.9667     456.6682       0.2281       0.2000     142.4422       0.1861       0.2378       5.9255    2319.9431     -11.5625    3637.0000
 1864.1568      20.7377      18.2332      38.1566      36.6526      30.7372     311.0000     116.2890     417.8799       0.1810       0.1512     136.0371       0.2282       0.2811       6.0869    2400.5071     -13.7500    3719.0000
 1864.3092      24.1793      17.7167      42.3760      31.8531      27.2752     311.0000     116.5456     404.0399       0.1053       0.0727     134.0730       0.2882       0.3421       5.2491    2529.9646     -16.8125    3760.0000
 1864.4616      27.2128      19.3719      65.4765      48.5604      43.8139     311.0000     105.3756     427.1672       0.1006       0.0679     130.3444       0.2399       0.2933       5.1962    2537.9802     -17.7500    3767.0000
 1864.6140      24.1454      21.0418      86.3430      68.7670      61.6142     311.0000      93.1720     473.9682       0.1023       0.0696     140.2984       0.0940       0.1409       5.9721    2535.0903     -17.7500    3753.0000
 1864.7664      27.8798      23.1522     128.3843     121.1866     109.6953     311.0000      81.2066     448.4735      -0.0252      -0.0625     151.9124       0.1217       0.1704       5.6140    2753.0881     -16.6250    3787.0000
 1864.9188      23.1003      25.2658     182.7490     112.4599     104.8435     311.0000      75.1630     454.3009      -0.0561      -0.0945     155.2625       0.1217       0.1699       5.6544    2805.9761     -16.0000    3687.0000
 1865.0712      26.2967      31.7327     200.3932      59.4954      56.3140     311.0000      72.6170     397.3931      -0.0633      -0.1020     150.1896       0.0936       0.1387       5.3276    2818.3159     -14.6250    3623.0000
 1865.2236      30.2021      41.3944     126.1944      47.0183      44.8876     311.0000      72.9212     382.7337      -0.0216      -0.0587     140.7940       0.0618       0.1027       5.1958    2746.8789     -12.6875    3614.0000
 1865.3760      37.5681      41.7580      78.3642      36.7283      34.9731     311.0000      74.7603     382.3694      -0.0249      -0.0622     135.4253       0.0503       0.0902       5.1692    2752.6016     -11.1875    3796.0000
 1865.5284      28.8251      25.9728      40.4264      29.9737      28.5328     311.0000      73.7572     381.6410       0.0934       0.0604     125.3963       0.0651       0.1063       5.4542    2550.3228      -7.0000    3867.0000
 1865.6808      17.9967      14.5180      16.1218      17.6432      16.7154     311.0000      73.1367     383.6441       0.0162      -0.0196     122.0872       0.0778       0.1209       5.3925    2682.2686      -6.2500    3766.0000
 1865.8332      23.7343      12.3172      12.0645      19.1127      18.5476     311.0000      70.1576     397.6663       0.0751       0.0415     131.2900       0.0615       0.1035       6.0279    2581.5024      -4.5000    3757.0000
 1865.9856      27.3246      26.6581      16.8523      15.8332      15.6392     311.0000      70.8920     399.4873       0.1127       0.0805     109.5469       0.0671       0.1103       5.5406    2517.2449      -2.6250    3714.0000
 1866.1380      22.9819      37.5778      24.6138      11.3150      11.2372     311.0000      70.2957     384.5547       0.2351       0.2073     108.7272       0.0936       0.1398       5.4846    2307.9907      -1.4375    3787.0000
 1866.2904      15.6121      26.9281      16.8060       9.9289       9.8691     311.0000      74.9477     391.9299       0.2763       0.2500     117.4326       0.2213       0.2740       6.6441    2237.4673      -1.4375    3726.0000
 1866.4428       6.6571       8.9733       7.9644       6.1839       6.1643     311.0000      83.3395     409.3210       0.2550       0.2279     158.7465       0.3120       0.3645       6.8395    2273.9585      -0.8750    3600.0000
 1866.5952      17.1870      17.7687      21.3760      12.7508      12.6833     311.0000      90.6600     417.8799       0.2483       0.2210     161.5229       0.2640       0.3155       6.3540    2285.4197       0.8125    3928.0000
 1866.7476      32.8288      16.9429      26.7510      24.0200      23.8728     311.0000      99.2915     466.5019       0.2103       0.1815     159.1172       0.1978       0.2489       6.3592    2350.4492       1.8750    3828.0000
 1866.9000      54.9457      18.6665      43.6166      42.1533      41.7990     311.0000      99.8629     487.9903       0.1610       0.1305     162.0624       0.2385       0.2904       6.0504    2434.6792       1.3125    3769.0000
 1867.0524     143.8083      22.2703      51.0575      54.2086      53.8684     311.0000      97.2068     489.9934       0.1387       0.1074     174.1886       0.3186       0.3704       5.7701    2472.8228       1.1250    3669.0000
 1867.2048     106.8598      39.5316      45.4662      33.9523      33.7758     311.0000      92.5424     464.3167       0.1393       0.1080     186.9457       0.2805       0.3308       6.3557    2471.8643       0.8750    3617.0000
 1867.3572      41.7052      33.1240      29.6392      20.5877      20.4619     311.0000      88.6498     499.8271       0.0553       0.0210     200.0639       0.2194       0.2694       5.5913    2615.3987      -0.1875    3731.0000
 1867.5096      20.3064      44.8535      28.3081      18.2254      18.0788     311.0000      88.4931     470.3261       0.0823       0.0490     230.6395       0.2200       0.2712       5.2948    2569.1938       2.0625    3763.0000
 1867.6620      21.8651      40.5801      30.1851      20.7166      20.4782     311.0000      84.1329     497.8240       0.1392       0.1079     247.0343       0.2221       0.2741       6.8434    2471.9363       3.3750    3681.0000
 1867.8144      28.5179      43.6310      40.1094      21.7204      20.6401     311.0000      85.4260     487.5350       0.1100       0.0776     233.6931       0.1942       0.2458       6.3053    2521.9778       5.1250    3704.0000
 1867.9668      44.9957      53.3280     106.5488      89.6340      83.4930     311.0000      81.7348     421.5220       0.0719       0.0382     199.7631       0.1985       0.2501       5.0829    2587.0354       5.8125    3777.0000
 1868.1192      49.8189      36.4217     145.0742     463.8544     375.8264     311.0000      87.0384     486.9887       0.1624       0.1319     185.1396       0.1708       0.2220       5.9610    2432.3752       6.0000    3864.0000
 1868.2716      32.6545      25.4961      42.8582     136.4195     123.5511     311.0000      87.8496     456.8503       0.1468       0.1158     194.0627       0.1739       0.2251       6.1852    2458.9263       4.6875    3833.0000
 1868.4240      20.0040      15.1431      38.0483      82.4207      74.4354     311.0000      93.6241     458.0341       0.1369       0.1055     200.2816       0.1678       0.2187       5.5296    2475.9541       5.1875    3662.0000
 1868.5764      20.6959      18.0114      15.2996      26.1259      24.1405     311.0000      96.0198     463.9525       0.1325       0.1009     188.3759       0.1813       0.2328       5.5604    2483.4368       5.0000    3716.0000
 1868.7288      14.8008      14.2792      17.0029      41.5064      37.4518     311.0000      97.4395     465.1361       0.1145       0.0822     182.2863       0.1578       0.2082       5.4707    2514.2881       3.5625    3855.0000
 1868.8812      22.8631      25.6398      32.1105      40.0335      36.8126     311.0000      96.4226     470.5082       0.1405       0.1093     176.2509       0.1885       0.2400       5.6605    2469.7280       1.1875    4047.0000
 1869.0336      22.1660      59.4044      58.8886      34.8008      32.6989     311.0000      93.3877     467.7767       0.1506       0.1197     173.0699       0.2156       0.2674       6.0908    2452.4927      -2.0000    3979.0000
 1869.1860      31.3011      35.7551      37.2752      26.9036      25.3362     311.0000      93.1849     454.4830       0.1117       0.0794     175.5650       0.1837       0.2348       5.7356    2518.9224      -1.4375    3893.0000
 1869.3384      31.3835      48.8320      26.8709      24.4488      22.6857     311.0000      95.6214     455.5756       0.0648       0.0308     181.0360       0.2336       0.2857       5.3505    2599.1548      -1.4375    3787.0000
 1869.4908      28.6512      33.9548      52.5859      39.8782      37.3827     311.0000      99.7206     463.4062       0.0845       0.0512     191.3276       0.2087       0.2609       5.3771    2565.5742      -1.4375    3822.0000
 1869.6432      35.0098      35.2200      80.0671      81.6962      73.6844     311.0000     103.0669     469.7798       0.0394       0.0044     188.9756       0.1736       0.2248       5.4627    2642.6946      -2.9375    3878.0000
 1869.7956      37.3892      36.3225     100.6921      96.1060      80.9959     311.0000     101.0629     483.9840       0.0298      -0.0055     186.4271       0.1346       0.1839       5.4193    2659.1228      -3.2500    3790.0000
 1869.9480      45.9092      35.3030      79.5291      86.5232      61.8987     311.0000      98.8903     406.1341       0.0235      -0.0120     171.9666       0.1176       0.1660       5.3789    2669.7346      -2.9375    3752.0000
 1870.1004      44.6099      29.6038      52.9545      45.2432      40.6947     311.0000      96.7608     443.5567       0.0334      -0.0018     159.0855       0.1224       0.1711       4.9479    2652.8933      -3.1250    3838.0000
 1870.2528      28.8146      18.0454      24.5354      25.1925      22.9221     311.0000      97.6419     455.5756       0.0421       0.0073     161.3710       0.1459       0.1959       5.1182    2638.0166      -3.5000    3942.0000
 1870.4052      25.5953      21.4861      27.0791      32.2875      28.3166     311.0000      96.6131     454.8472       0.0720       0.0382     175.4224       0.1626       0.2134       5.2863    2586.9175      -2.8750    3876.0000
 1870.5576      33.7023      29.1492      34.8844      37.3516      33.8847     311.0000      95.3963     450.1125       0.0322      -0.0030     195.3929       0.1613       0.2120       5.4901    2654.9077      -2.5625    3814.0000
 1870.7100      29.1101      23.7949      30.7155      25.2957      24.2046     311.0000      99.0745     442.7373       0.0091      -0.0270     207.7067       0.1751       0.2264       5.3449    2694.4722      -1.4375    3774.0000
 1870.8624      38.2148      25.0217      19.9003      17.0444      16.1455     311.0000     101.5229     462.4957       0.0408       0.0059     211.0469       0.1437       0.1936       5.3853    2640.2637      -2.5000    3892.0000
 1871.0148      21.4677      41.4663      34.5119      21.1247      19.7065     311.0000      99.0667     468.6872       0.0369       0.0018     210.8819       0.1653       0.2162       5.6598    2646.9749      -2.2500    3905.0000
 1871.1672      27.0393      42.6181      30.1845      19.1963      18.0127     311.0000      93.9764     476.6998       0.0660       0.0320     216.4783       0.2010       0.2531       5.8408    2597.1990      -3.6250    3784.0000
 1871.3196      24.0795      51.6627      42.1915      29.1433      26.7108     311.0000      91.5937     488.3545       0.0933       0.0603     236.1562       0.2206       0.2729       6.2229    2550.4521      -3.6250    3770.0000
 1871.4720      20.5980      18.3766      28.2185      29.2010      27.2771     311.0000      94.8611     493.9998       0.0585       0.0243     275.2657       0.2256       0.2783       5.8572    2609.9553      -4.9375    3828.0000
 1871.6244      30.6570      27.3830      36.7817      46.3632      40.4691     311.0000      94.0014     482.6182       0.0468       0.0121     335.9763       0.2501       0.3030       5.4289    2630.0112      -4.3750    3763.0000
 1871.7768      38.7348      15.1294      25.6502      51.8880      44.7767     311.0000      90.1987     480.5240       0.0649       0.0309     384.4502       0.1262       0.1752       6.5386    2598.9722      -6.2500    3827.0000
 1871.9292      47.9394      19.1925      52.9945     102.5441      80.9641     311.0000      83.7956     489.8114       0.0531       0.0187     378.9418       0.1238       0.1726       6.5687    2619.2068      -7.6250    3888.0000
 1872.0816      40.5202      47.2453     133.0903     392.1841     242.3673     311.0000      84.1482     459.0356       0.0230      -0.0125     316.8070       0.1161       0.1641       5.9357    2670.6409      -8.0000    3873.0000
 1872.2340      40.4909     147.7930      83.1312     101.0845      80.3533     311.0000      84.2496     480.1598       0.0288      -0.0065     232.1191       0.1058       0.1528       5.4012    2660.6975      -6.8125    3883.0000
 1872.3864      33.5064     148.3650      74.0652     106.9878      75.8937     311.0000      84.2496     401.8547       0.0501       0.0156     187.4580       0.1113       0.1589       5.5929    2624.2573      -5.4375    4042.0000
 1872.5388      37.5829      27.2149      17.9793      20.4769      19.1241     311.0000      83.0328     400.2157       0.1238       0.0919     180.6197       0.1527       0.2029       5.8572    2498.2942      -6.6875    3923.0000
 1872.6912      15.8747      11.8985       8.7169      10.1613       9.7419     311.0000      83.5398     391.1105       0.0863       0.0530     230.5706       0.1955       0.2475       6.0502    2562.5022      -6.2500    3802.0000
 1872.8436       9.2752       6.5803       5.1851      10.1663       9.5444     311.0000      82.7829     432.8125       0.0471       0.0125     281.8389       0.1635       0.2142       5.9019    2629.4512      -6.6250    3810.0000
 1872.9960      26.7417      17.1604      11.5882      12.1181      11.6093     311.0000      76.8003     452.6620      -0.0024      -0.0388     310.8554       0.1024       0.1492       5.4860    2714.0847      -4.9375    4054.0000
 1873.1484      53.2187      56.7430      24.4042      15.8032      15.1976     311.0000      73.7582     447.5630       0.0561       0.0217     301.7266       0.0663       0.1104       6.1995    2614.1440      -5.6875    4028.0000
 1873.3008      40.0027      49.2827      22.6770      16.6439      15.7825     311.0000      77.6653     444.1030       0.0318      -0.0034     242.5547       0.0963       0.1427       5.5208    2655.6345      -4.8750    3920.0000
 1873.4532      32.3841      44.6037      29.6991      20.8545      19.6871     311.0000      88.0939     427.8956       0.1432       0.1121     203.0296       0.1377       0.1873       5.2162    2465.0500      -5.0000    3860.0000
 1873.6056      16.5304      39.4749      27.5916      25.7915      24.3360     311.0000      95.3198     419.5189       0.1728       0.1428     173.6891       0.2490       0.3024       6.2598    2414.4436      -4.3750    3954.0000
 1873.7580      19.3987      15.8458      23.8512      36.9661      34.4250     311.0000     102.4260     440.8251       0.1074       0.0750     186.4173       0.2681       0.3212       5.4146    2526.3213      -5.2500    3838.0000
 1873.9104      24.0744      10.5783      17.2793      66.2292      61.7539     311.0000     105.6865     452.8441       0.0591       0.0248     195.1387       0.1656       0.2164       5.4971    2609.0066      -5.4375    3810.0000
 1874.0628      25.2739      17.9465      42.2645      89.0239      84.3618     311.0000     107.2921     460.1283       0.0345      -0.0006     195.6463       0.1852       0.2367       5.0803    2650.9377      -6.8125    3842.0000
 1874.2152      21.5399      19.3964      52.8549      72.9454      71.4774     311.0000     110.0299     439.9146       0.0742       0.0406     191.5262       0.1861       0.2379       5.1700    2583.0571      -6.3750    3840.0000
 1874.3676      21.0179      22.9355      59.0209      39.7439      38.5519     311.0000     110.2009     441.0983       0.0939       0.0609     179.1954       0.1999       0.2521       4.7448    2549.4500      -8.0625    3818.0000
 1874.5200      17.7245      22.1297      30.0248      35.6095      35.6777     311.0000     103.7017     435.3620       0.0594       0.0252     178.9296       0.1143       0.1625       4.9760    2608.3899      -7.0000    3805.0000
 1874.6724      26.3295      38.4960      31.8188      25.3530      25.5531     311.0000      85.5277     424.6178      -0.0139      -0.0508     177.9547       0.0954       0.1422       5.8795    2733.7488      -7.7500    3696.0000
 1874.8248      30.0036      54.4639      85.7356      62.1361      63.1502     311.0000      69.1325     416.0589       0.0411       0.0062     199.0206       0.1071       0.1543       4.9011    2639.6973      -5.2500    3801.0000
 1874.9772      29.2376      69.9228     178.3424      90.1708      92.2727     311.0000      70.7660     403.1294       0.0151      -0.0207     222.1868       0.0979       0.1440       5.6859    2684.2031      -1.4375    4034.0000
 1875.1296      24.5815      24.7079      37.1583      43.6007      45.8360     311.0000      79.5097     375.8137       0.0083      -0.0277     241.8544       0.1187       0.1665       5.5925    2695.7869      -1.4375    4040.0000
 1875.2820      17.3104       9.2346      14.8189      23.4581      24.6061     311.0000      86.9303     377.8168      -0.0296      -0.0671     215.4684       0.1630       0.2137       5.3393    2760.6382      -1.4375    3931.0000
 1875.4344      13.3854       7.7791      10.3702      20.2972      21.1619     311.0000      86.6150     390.3820      -0.0154      -0.0523     160.5744       0.1625       0.2133       5.0035    2736.2756      -1.4375    3844.0000
 1875.5868       8.7739       9.0825      11.9188      17.0657      17.6349     311.0000      85.2277     377.7258       0.0715       0.0377     111.3064       0.1103       0.1583       5.6731    2587.7563      -1.4375    3832.0000
 1875.7392       9.1722      14.4726      18.8188      15.6742      16.1221     311.0000      87.9472     397.4842       0.2188       0.1904     104.4838       0.1566       0.2071       6.0295    2335.9155      -0.0625    3857.0000
 1875.8916      11.8804      27.0040      17.2586      12.9279      13.1954     311.0000      92.2632     379.0916       0.1855       0.1558     102.8299       0.2154       0.2670       5.9119    2392.8672       2.9375    3892.0000
 1876.0440      14.9217      22.1626      34.3502      14.9692      15.3242     311.0000      99.8360     394.3884       0.1140       0.0818     105.0324       0.2448       0.2964       5.0047    2515.0984       1.8750    3828.0000
 1876.1964      18.8285      31.0919      18.3343      13.4216      13.6314     311.0000     105.0098     394.5704       0.1367       0.1053     107.3837       0.2439       0.2956       4.8191    2476.2144       3.3125    3888.0000
 1876.3488      12.8752      15.9852      22.4558      19.8413      20.2006     311.0000     102.0120     400.9441       0.1600       0.1294     145.9172       0.2261       0.2777       5.3825    2436.4128       2.7500    3851.0000
 1876.5012      17.9382      17.9347      19.8506      20.7524      21.0603     311.0000     101.0383     390.2910       0.1337       0.1021     211.3128       0.2380       0.2897       6.0232    2481.4578       3.0625    3881.0000
 1876.6536      12.6923      12.1374      13.3557      14.6073      14.7323     311.0000     100.1233     445.0135       0.1085       0.0761     258.3818       0.1937       0.2448       6.3155    2524.4985       1.0000    3823.0000
 1876.8060      21.2604      16.1606      19.2893      12.6528      12.6856     311.0000     100.3098     441.6446       0.0825       0.0492     266.6376       0.1860       0.2371       6.5496    2568.8765       2.3125    3890.0000
 1876.9584      32.5644      29.7378      32.4944      23.8515      23.7941     311.0000      98.6471     394.2063       0.0391       0.0042     237.1662       0.2389       0.2913       5.5917    2643.0786       2.9375    3941.0000
 1877.1108      20.0649      18.8308      17.6825      13.4528      13.3684     311.0000      93.7798     388.3789       0.0192      -0.0164     220.4790       0.3197       0.3731       5.0395    2677.0935       1.6875    3879.0000
 1877.2632       8.6233       7.4370       6.2372       5.1608       5.1294     311.0000      89.8872     400.9441      -0.0158      -0.0527     213.5549       0.1879       0.2391       5.2292    2736.9783       1.3125    4009.0000
 1877.4156      19.7195      19.2379      10.2186      10.1887      10.0519     311.0000      81.6737     394.1152      -0.0245      -0.0618     215.3935       0.1260       0.1749       5.4433    2751.8921       1.8750    3891.0000
 1877.5680      28.8173      35.6558      29.0010      24.4322      23.8906     311.0000      76.1981     377.9989      -0.0395      -0.0773     195.0891       0.1069       0.1545       5.2598    2777.5674       4.4375    4061.0000
 1877.7204      27.0079      40.5299      43.3434      40.9432      38.6885     311.0000      75.2249     367.6189      -0.0270      -0.0644     172.2856       0.1168       0.1644       5.2513    2756.2097       4.2500    3995.0000
 1877.8728      27.7156      43.2152      90.2290      73.7703      66.4317     311.0000      79.2593     362.7021      -0.0102      -0.0470     149.2462       0.1121       0.1593       4.8458    2727.5176       5.0000    3888.0000
 1878.0252      28.5088      25.8211      50.9394      37.9161      35.3148     311.0000      79.1579     363.2484       0.0685       0.0346     154.0382       0.1124       0.1599       4.9610    2592.9321       4.9375    3828.0000
 1878.1776      30.0413      25.0903      40.5698      38.3742      36.0865     311.0000      78.9699     372.5358       0.0660       0.0321     163.4912       0.1348       0.1838       5.8303    2597.0874       6.3125    3867.0000
 1878.3300      23.3708      13.4925      15.3415      22.5066      21.7883     311.0000      78.6312     393.1136       0.0639       0.0298     168.6649       0.1489       0.1985       5.1776    2600.7522       5.3750    3893.0000
 1878.4824      18.8490      17.5448      25.2368      32.0024      30.6688     311.0000      81.5718     392.4763       0.0477       0.0131     159.2398       0.1325       0.1815       4.7287    2628.3491       6.0625    3863.0000
 1878.6348      30.8754      31.3899      33.6871      39.2321      36.1993     311.0000      81.5718     394.5704       0.0057      -0.0304     129.0243       0.1253       0.1740       4.6693    2700.1765       5.3125    3705.0000
 1878.7872      51.5165      54.0576      61.5367      38.0937      36.0507     311.0000      80.7068     365.0695       0.0320      -0.0032     108.2504       0.1262       0.1751       4.7518    2655.3494       5.4375    3653.0000
 1878.9396     191.1287      95.2236     129.0555      59.4625      55.2980     311.0000      76.9550     388.0147       0.0174      -0.0184     107.6598       0.1321       0.1813       4.8528    2680.2957       3.8750    3736.0000
 1879.0920      87.9076      44.1717      48.2232      50.6995      48.3408     311.0000      78.8868     383.0978       0.0023      -0.0340     134.5358       0.1178       0.1656       4.9004    2706.1487       2.3125    3885.0000
 1879.2444      55.2383      33.6526      28.3124      37.1738      36.0083     311.0000      81.8217     386.3757      -0.0449      -0.0829     152.5135       0.0979       0.1435       5.2196    2786.7925       1.3750    3873.0000
 1879.3968      34.2544      24.1564      41.6251      52.4554      50.4177     311.0000      82.3265     363.2484      -0.0537      -0.0920     151.6213       0.0887       0.1328       4.9972    2801.7925       2.2500    3996.0000
 1879.5492      66.5185      35.4858      47.3860      35.1038      33.6462     311.0000      79.8877     360.6989      -0.0410      -0.0789     142.6160       0.0746       0.1179       4.9149    2780.1306       3.5625    4099.0000
 1879.7016     136.3476      75.8815      71.4950      51.8325      50.1799     311.0000      73.5137     360.5168      -0.0456      -0.0836     150.7847       0.0653       0.1083       4.8066    2787.9377       4.0625    3960.0000
 1879.8540     115.4575      50.3953      33.0866      39.3664      38.0474     311.0000      73.9341     361.3363       0.0227      -0.0128     185.8370       0.1023       0.1486       5.1633    2671.1968       4.4375    4002.0000
 1880.0064      91.5851      26.9502      17.9223      45.5667      44.4512     311.0000      74.5425     374.9942       0.0495       0.0150     209.9311       0.1531       0.2028       5.2479    2625.3152       3.7500    3802.0000
 1880.1588      59.0065      44.3311      25.8583      42.0598      40.8104     311.0000      73.3257     372.9000       0.0203      -0.0153     211.2341       0.0868       0.1325       5.1580    2675.2205       3.6250    3830.0000
 1880.3112      37.4829      26.5811      19.1700      24.7035      24.2538     311.0000      71.4875     361.7916      -0.0054      -0.0420     177.2361       0.1336       0.1826       5.7369    2719.2708       5.0625    3984.0000
 1880.4636      16.4512      15.6681      11.2339      19.2122      18.8184     311.0000      72.5016     359.9705       0.0367       0.0017     153.1677       0.1392       0.1887       5.0290    2647.2397       5.7500    3915.0000
 1880.6160      19.5715      27.2533      11.1976      10.1856      10.0872     311.0000      74.8994     363.0663       0.0826       0.0493     145.9327       0.1199       0.1685       5.9155    2568.6716       5.5000    3824.0000
 1880.7684      19.6027      43.8824      20.9290      12.5279      12.3101     311.0000      81.1730     358.0584       0.0816       0.0482     149.2031       0.1192       0.1678       5.5827    2570.4009       7.0625    3903.0000
 1880.9208      18.5400      59.0904      27.0219      15.0030      14.6869     311.0000      84.5857     350.6832       0.2106       0.1819     166.1849       0.1822       0.2338       5.7426    2349.8779       7.0000    4028.0000
 1881.0732      20.4664      19.7441      21.9463      14.0581      13.6738     311.0000      90.7056     412.2347       0.2442       0.2167     172.9341       0.2094       0.2617       6.3242    2292.3860       6.8750    3882.0000
 1881.2256      16.1007      10.0303      10.6366      13.3627      12.9194     311.0000      88.0002     438.6398       0.2695       0.2429     188.4067       0.2721       0.3249       6.1553    2249.2112       7.0000    3785.0000
 1881.3780      40.9157      15.5711      21.8928      29.5237      28.6610     311.0000      88.5411     468.4140       0.3006       0.2752     169.3033       0.2776       0.3298       6.6915    2196.0000       4.5000    3908.0000
 1881.5304     102.1531      39.2068      43.5973      61.4874      59.8985     311.0000      83.1668     445.5599       0.4506       0.4306     156.0408       0.2091       0.2609       6.9915    1939.4961       2.0625    3858.0000
 1881.6828     137.7385      51.5577      70.3992      80.6820      78.9871     311.0000      81.4368     437.0009       0.4385       0.4181     142.0939       0.1679       0.2189       7.5338    1960.1989       0.3125    4023.0000
 1881.8352      66.6276      71.1958     103.2097      78.6500      75.6116     311.0000      79.8154     449.2930       0.3151       0.2902     166.3423       0.1436       0.1934       6.7095    2171.1138      -0.3750    3957.0000
 1881.9876      38.0459      50.1324      53.0187      30.1747      29.9154     311.0000      81.6406     437.3652       0.1821       0.1523     217.2034       0.1825       0.2339       6.3593    2398.6382       0.8750    3887.0000
 1882.1400      24.2515      20.7449      18.8832      17.0582      16.8183     311.0000      80.9918     393.2957       0.0437       0.0090     242.4007       0.2017       0.2538       5.9301    2635.2024      -0.9375    3972.0000
 1882.2924      34.7115      44.4397      40.3492      26.8487      26.2787     311.0000      78.6596     404.2220       0.0660       0.0320     252.4652       0.1698       0.2208       5.3031    2597.2202      -1.4375    3970.0000
 1882.4448      27.7321      35.0979      37.0311      32.8168      32.0922     311.0000      84.5269     450.6588       0.0691       0.0352     239.0285       0.1748       0.2260       5.2178    2591.9031      -0.8750    3845.0000
 1882.5972      12.9921      13.3753      17.3019      19.4751      19.1384     311.0000      90.2577     453.3904       0.0774       0.0438     246.7384       0.2113       0.2634       5.7471    2577.6787      -1.4375    4005.0000
 1882.7496      28.0974      27.9630      41.3064      47.0085      46.0176     311.0000      94.3137     455.9398       0.0778       0.0443     246.0449       0.1860       0.2374       5.6440    2576.9575      -3.8125    4077.0000
 1882.9020      30.9301      34.0432      50.6414      58.4343      57.3826     311.0000      93.1075     458.0341       0.0922       0.0592     229.2256       0.1914       0.2428       5.5857    2552.3879      -4.5625    3869.0000
 1883.0544      35.8523      42.1648      54.0973      55.4682      54.5409     311.0000      90.9536     433.7231       0.0761       0.0425     190.4371       0.2068       0.2588       5.3269    2579.9248      -5.2500    3903.0000
 1883.2068      20.0445      32.2955      40.6659      41.1106      40.5838     311.0000      90.7507     423.1609       0.0461       0.0114     149.0982       0.1473       0.1974       4.9291    2631.2170      -8.5625    3979.0000
 1883.3592      34.5309      72.4940      70.8240      61.0266      59.7034     311.0000      85.0334     427.1672       0.0282      -0.0072     131.3469       0.1317       0.1809       5.1274    2661.8149     -10.2500    3930.0000
 1883.5116      34.8350     170.8936      64.9684      62.2486      60.6619     311.0000      85.4259     425.7104      -0.0190      -0.0561     131.1438       0.1406       0.1901       4.7687    2742.5361     -11.1875    3899.0000
 1883.6640      23.0040      84.5082      39.8346      41.8917      41.1232     311.0000      82.0796     376.9063      -0.0173      -0.0543     153.6980       0.1438       0.1936       4.6574    2739.6487     -11.5625    3908.0000
 1883.8164      21.6569      25.3238      21.6415      22.6195      22.3333     311.0000      78.5096     364.6142      -0.0503      -0.0885     157.4721       0.1569       0.2071       5.0876    2796.0281     -13.6250    3911.0000
 1883.9688      10.0622      10.1650       9.9191      10.1160      10.0640     311.0000      70.2078     356.5105      -0.0895      -0.1291     166.3442       0.1177       0.1657       4.5302    2863.0679     -13.6875    3835.0000
 1884.1212      19.7484      21.4678      20.0342      16.1059      15.9042     311.0000      61.6370     353.1416       0.0113      -0.0246     156.0903       0.0808       0.1257       4.9542    2690.6255     -13.3750    3966.0000
 1884.2736      29.0441      51.3867      45.0654      23.0067      22.5879     311.0000      58.3540     358.6958      -0.0227      -0.0599     138.7749       0.0466       0.0879       4.4356    2748.8098     -13.0625    3907.0000
 1884.4260      18.8423      44.8845      36.4999      21.5882      21.0840     311.0000      60.8483     386.1937       0.0792       0.0457     115.6879       0.0807       0.1240       5.8561    2574.6055     -13.6250    3838.0000
 1884.5784      21.6969      25.7484      43.2257      28.2034      27.2269     311.0000      69.1150     361.6095      -0.0214      -0.0586      76.9782       0.1611       0.2098       4.7903    2746.6743     -11.8125    3925.0000
 1884.7308      20.8299      15.3370      41.5295      24.4070      23.1362     311.0000      72.0734     385.1010      -0.0487      -0.0869      55.7480       0.1201       0.1671       4.1884    2793.3618     -11.1875    3904.0000
 1884.8832      14.3359      10.1343      25.7610      27.1664      25.1054     311.0000      69.7819     362.1558      -0.0445      -0.0825      29.6588       0.0625       0.1056       4.2481    2786.0476     -11.1875    3947.0000
 1885.0356      15.3240       9.3515      21.6540      26.8205      24.7656     311.0000      64.7591     367.4369      -0.0394      -0.0771      29.5954       0.0570       0.0992       4.2227    2777.2905      -9.8125    4030.0000
 1885.1880      16.0463      15.7620      29.0187      29.6592      27.2090     311.0000      65.8567     393.1136       0.1234       0.0915      61.2798       0.0804       0.1250       4.5115    2499.0103     -10.1250    3975.0000
 1885.3404      16.7922      18.9959      22.5074      16.8214      16.8367     311.0000      71.0281     362.5200       0.1699       0.1397     113.5585       0.1403       0.1896       5.8042    2419.5115      -9.4375    3848.0000
 1885.4928      16.1136      28.7773      16.1091      11.3528      10.9495     311.0000      76.1101     420.4294       0.2608       0.2339     164.8753       0.1460       0.1961       6.5393    2263.9927      -8.5000    3881.0000
 1885.6452      19.3064      43.3197      18.2509      11.7563      11.3234     311.0000      79.3550     395.4810       0.2191       0.1907     174.1405       0.2467       0.2991       6.0036    2335.3086      -8.5000    3874.0000
 1885.7976      12.0111      57.9976      21.0301      12.8099      12.3196     311.0000      81.4624     422.4325       0.2314       0.2035     159.2667       0.2559       0.3079       5.4130    2314.2341      -7.4375    3901.0000
 1885.9500      13.1326      29.1315      27.9895      17.8769      16.5483     311.0000      83.1137     457.0325       0.2698       0.2432     138.4671       0.2435       0.2941       6.0480    2248.6670      -6.6875    3825.0000
 1886.1024      23.4530      41.8930      62.5761      40.9884      38.5411     311.0000      85.8030     469.2335       0.2783       0.2521     109.4120       0.2887       0.3392       5.7599    2234.0967      -7.1875    3757.0000
 1886.2548      19.6262      14.8377      30.6492      72.1496      68.4971     311.0000      84.5068     493.2713       0.3291       0.3047      96.6404       0.3025       0.3520       5.7823    2147.2095      -8.4375    3796.0000
 1886.4072       8.0401       6.2854      11.3301     194.7355     183.7942     311.0000      81.2336     468.1408       0.2182       0.1898      78.1481       0.3943       0.4436       6.0666    2336.8064      -9.8750    3827.0000
 1886.5596      13.1927       8.4744      23.7905     201.5926     192.5415     311.0000      75.0673     487.2619       0.0341      -0.0010      83.9973       0.2176       0.2704       4.8668    2651.7190      -9.8125    4024.0000
 1886.7120      17.9442      13.8374      52.7111     261.0880     251.6998     311.0000      74.3575     489.9934      -0.0131      -0.0500      95.7441       0.0442       0.0855       5.0119    2732.4670      -9.2500    4004.0000
 1886.8644      14.9961      14.4168      31.3636      31.7126      30.3695     311.0000      71.9787     451.5693      -0.0041      -0.0406     119.3299       0.0538       0.0947       5.1921    2717.0493      -8.1875    3879.0000
 1887.0168      13.4188      15.8040      14.0154       9.8570       9.5419     311.0000      71.0954     416.4230      -0.0043      -0.0408     143.8072       0.0581       0.0997       4.6484    2717.3721      -7.4375    3907.0000
 1887.1692       8.5524      14.4616      15.7321      14.0143      13.7740     311.0000      71.7038     377.4526       0.0359       0.0008     165.7510       0.0606       0.1033       4.8384    2648.6821      -5.6250    3984.0000
 1887.3216      10.8955      22.9784      14.3921      11.0597      10.5725     311.0000      76.0289     389.2894       0.1383       0.1070     175.7233       0.0921       0.1376       5.2935    2473.4587      -5.3750    3750.0000
 1887.4740      18.8645      42.0728      26.3428      17.2699      16.1100     311.0000      82.2144     402.5831       0.1539       0.1232     174.3708       0.1176       0.1650       5.2354    2446.7991      -3.8750    3833.0000
 1887.6264      31.1548     127.2422     110.2127      23.2696      20.7768     311.0000      82.7466     417.5157       0.1311       0.0995     170.7559       0.1266       0.1746       5.0777    2485.8364      -8.1875    3998.0000
 1887.7788      25.9933      48.3338     137.1187      21.9848      20.8766     311.0000      82.6545     434.9978       0.1388       0.1075     187.4604       0.1968       0.2486       5.4985    2472.5681      -9.0000    4026.0000
 1887.9312      25.8982      33.7052      79.4711      56.2057      47.8422     311.0000      77.4605     435.7262       0.1096       0.0772     207.6271       0.1850       0.2353       5.9301    2522.5632     -10.7500    3988.0000
 1888.0836      24.4228      18.9689      50.9438      63.1082      49.5820     311.0000      75.3929     435.5441       0.0169      -0.0189     218.9899       0.0972       0.1418       5.4408    2681.1482      -9.3750    3849.0000
 1888.2360      19.9301      17.6135      41.2665      42.2293      38.4727     311.0000      73.7833     415.8767      -0.0305      -0.0679     219.7254       0.0305       0.0690       5.1673    2762.0894      -9.5000    3869.0000
 1888.3884      21.0723      19.8908      36.7865      27.3651      25.8952     311.0000      76.1381     388.3789      -0.0686      -0.1074     203.5270       0.0442       0.0844       5.3417    2827.2207      -8.0625    3997.0000
 1888.5408      11.5929      13.4712      16.8007      12.1614      11.5783     311.0000      78.4087     375.8137      -0.0742      -0.1132     178.8487       0.0756       0.1182       4.6363    2836.8154      -7.3750    3858.0000
 1888.6932       8.5306      13.9019      14.0648      10.7198      10.4215     311.0000      77.9605     378.5452      -0.0186      -0.0557     150.2635       0.0582       0.0996       4.6778    2741.8367      -7.1250    3788.0000
 1888.8456      20.9738      31.7202      25.7673      17.9134      17.2158     311.0000      76.4395     382.9157      -0.0444      -0.0823     120.3089       0.0602       0.1019       4.5206    2785.8538      -5.1875    3818.0000
 1888.9980      42.0982      36.5118      27.0233      21.4900      20.0360     311.0000      82.0924     386.5579      -0.0667      -0.1055      91.9065       0.0844       0.1285       4.6073    2824.0916      -1.4375    4037.0000
 1889.1504      22.2176      20.3876      14.8924      13.8888      12.7311     311.0000      83.3774     387.5594      -0.0072      -0.0439      62.8183       0.1234       0.1706       4.8071    2722.3538       1.1875    4237.0000
 1889.3028      41.0356      34.7404      19.8667      20.4753      18.7887     311.0000      86.8709     392.2031       0.0653       0.0313      54.8058       0.1133       0.1604       4.5052    2598.4177       1.6875    4064.0000
 1889.4552      72.1030      47.4255      32.1626      38.3776      33.1929     311.0000      81.6994     396.5736       0.1140       0.0817      60.5307       0.1428       0.1922       5.2426    2515.1323       1.8125    3925.0000
 1889.6076     195.1637      32.6579      25.0298      33.3003      28.7028     311.0000      81.1588     435.0888       0.0727       0.0390      95.3028       0.1227       0.1711       5.0753    2585.6155       1.9375    3860.0000
 1889.7600      66.3071      26.0730      20.2618      35.4868      30.2026     311.0000      81.9016     452.6620       0.0596       0.0254     151.9084       0.1058       0.1531       5.5044    2608.0967       4.5000    3913.0000
 1889.9124      38.5315      30.3329      17.7548      21.8228      19.2217     311.0000      82.6114     443.2835       0.0821       0.0487     186.8501       0.1191       0.1672       6.1165    2569.6152       6.8125    3936.0000
 1890.0648      17.6192      32.0904      19.6262      19.8327      18.3478     311.0000      82.5181     431.1735       0.1214       0.0895     196.7773       0.1245       0.1730       6.2026    2502.3596       7.8750    3809.0000
 1890.2172      24.3646      25.3405      13.7642      10.5743      10.1610     311.0000      81.3426     435.3620       0.0976       0.0648     177.8030       0.0941       0.1407       6.2299    2543.0891       8.3750    3826.0000
 1890.3696       9.7911       7.7209       5.1403       4.1780       4.1378     311.0000      78.7456     418.0620       0.2341       0.2062     167.3155       0.1391       0.1886       5.9948    2309.7454       8.3750    4017.0000
 1890.5220      13.0921      15.8063       8.8686       5.9221       5.8100     311.0000      79.3928     476.0625       0.2376       0.2098     167.1627       0.2302       0.2834       7.2180    2303.7708       8.3750    4011.0000
 1890.6744      13.9637      19.8690      13.0407       7.6322       7.4996     311.0000      81.5909     460.1283       0.1515       0.1206     179.4767       0.1918       0.2436       5.9048    2451.0037       8.3750    4035.0000
 1890.8268       7.7930      13.3908      13.9529       9.6054       9.3902     311.0000      82.2525     478.2477       0.1285       0.0968     206.7990       0.1253       0.1739       5.7706    2490.2903       8.3750    4061.0000
 1890.9792       7.9799       6.5552      10.4519       9.3860       9.2132     311.0000      81.6053     504.3797       0.2713       0.2448     230.8271       0.2363       0.2887       6.3625    2246.0454       8.3750    4083.0000
 1891.1316      23.3323      12.4772      13.4246      16.3292      15.7219     311.0000      75.1764     530.1476       0.3853       0.3630     217.9012       0.2567       0.3096       7.5321    2051.0547       8.3750    3974.0000
 1891.2840      41.0246       6.6699      12.6204      26.5989      24.5735     311.0000      70.1150     551.1807       0.3929       0.3708     193.1100       0.2317       0.2832       6.9714    2038.1753       7.7500    3966.0000
 1891.4364      27.1161       7.4647      10.1267      35.7067      32.1880     311.0000      67.1922     601.9880       0.3708       0.3479     166.7776       0.3124       0.3631       7.0624    2075.9937       6.4375    3897.0000
 1891.5888      18.9810       9.3488      16.9767      25.6887      23.5211     311.0000      67.2358     616.4654       0.2458       0.2184     227.1109       0.2353       0.2867       7.0024    2289.6265       5.6250    3889.0000
 1891.7412      20.1302      26.2594      22.5550      20.3239      19.1339     311.0000      71.5399     616.5565       0.0819       0.0485     282.1958       0.1768       0.2281       6.9922    2570.0225       4.0000    3907.0000
 1891.8936      16.0519      27.0867      14.8392       7.4408       7.2437     311.0000      74.8804     598.1638       0.0059      -0.0303     297.4613       0.1032       0.1507       5.8938    2699.9187       4.2500    3784.0000
 1892.0460       4.2410       8.5057       6.4479       4.7397       4.6614     311.0000      76.0069     510.4803       0.0873       0.0541     231.2150       0.1433       0.1931       5.1097    2560.6563       3.4375    3917.0000
 1892.1984       8.3607      12.5559       8.6042       5.6759       5.5477     311.0000      76.2233     526.5966       0.1282       0.0965     172.8485       0.1983       0.2500       5.1580    2490.7058       0.5625    3950.0000
 1892.3508      10.1261      11.8010      10.8805       8.9043       8.7133     311.0000      80.6565     529.8745       0.1423       0.1111     153.3084       0.2628       0.3135       5.4664    2466.6289      -1.4375    3982.0000
 1892.5032      12.3639      12.6919      15.3639      15.7978      15.3803     311.0000      87.8952     550.0881       0.0879       0.0547     148.3150       0.3435       0.3912       4.9931    2559.7312      -1.5625    3988.0000
 1892.6556      12.2030      11.4100      22.8721      35.6673      34.5554     311.0000      96.9824     570.0286       0.0960       0.0631     142.8280       0.3337       0.3827       4.7970    2545.9036      -6.0625    4045.0000
 1892.8080      18.3420      13.8860      22.6102      35.1393      34.2285     311.0000      99.0368     559.0112       0.1565       0.1259     124.6817       0.2428       0.2935       5.7985    2442.3123      -6.9375    3958.0000
 1892.9604      12.0458       6.5790       8.8871      10.8275      10.6271     311.0000      97.7623     584.8702       0.0750       0.0414      98.9373       0.2881       0.3396       5.5010    2581.7493      -7.1250    3942.0000
 1893.1128      12.6945      10.6355      13.8639      23.8272      22.3557     311.0000      93.1477     586.6912       0.0627       0.0286      80.1768       0.2132       0.2657       5.0638    2602.7388      -9.7500    3925.0000
 1893.2652      14.6658      21.7580      28.0647      34.6007      33.0296     311.0000      88.2820     562.2891       0.1328       0.1013      82.6585       0.0985       0.1456       4.9067    2482.8303     -10.2500    3883.0000
 1893.4176      14.7800      57.4406      52.7602      37.1147      35.7569     311.0000      86.3379     515.6703       0.2988       0.2734     118.8564       0.1031       0.1501       6.0847    2198.9673     -11.1875    3849.0000
 1893.5700      16.2528      23.1644      19.4414      28.3696      25.7298     311.0000      88.8885     551.3628       0.2283       0.2002     157.8019       0.1283       0.1768       7.0118    2319.6018     -11.1875    3834.0000
 1893.7224       9.4545       8.5728       6.8269       6.4167       6.2462     311.0000      91.1591     580.4086       0.0812       0.0478     184.0391       0.1395       0.1888       5.9604    2571.1121     -11.7500    3923.0000
 1893.8748      21.1198      23.1655      19.0515      15.3942      14.7382     311.0000      88.1207     597.3444       0.0029      -0.0334     178.2007       0.1290       0.1778       5.3371    2705.0928     -13.0000    4039.0000
 1894.0272      33.9022      50.3342      29.2597      24.4990      23.3767     311.0000      84.2347     591.9722       0.0372       0.0022     159.0350       0.1354       0.1845       5.2847    2646.3047     -12.8125    4048.0000
 1894.1796      23.6865      66.6450      30.9286      18.8637      18.2627     311.0000      80.2340     532.8792       0.0535       0.0191     132.9932       0.1174       0.1656       5.4254    2618.5361     -13.5625    3982.0000
 1894.3320      19.1895      53.4336      32.2449      18.2598      17.5924     311.0000      80.1181     561.8339       0.1219       0.0900     115.9685       0.1111       0.1588       4.8467    2501.5488     -11.1875    3964.0000
 1894.4844      33.8831      54.6166      37.2073      23.8821      22.8286     311.0000      77.5218     524.7755       0.2536       0.2264     124.1457       0.1305       0.1795       6.0728    2276.3665     -11.1875    3957.0000
 1894.6368      37.5887      36.5737      41.4794      32.6987      31.2249     311.0000      79.0356     552.8197       0.2468       0.2194     147.5534       0.1435       0.1934       6.8640    2288.0264     -11.1875    3826.0000
 1894.7892      30.9994      21.1185      28.4152      34.5368      33.0292     311.0000      79.0356     600.7133       0.1844       0.1547     167.2366       0.1734       0.2245       5.9630    2394.7458     -11.1875    3855.0000
 1894.9416      28.1596      12.9347      16.4500      24.5691      23.7916     311.0000      82.7137     604.1733       0.1592       0.1286     176.4095       0.2490       0.3015       5.8572    2437.7478     -11.0625    3826.0000
 1895.0940      17.0518      12.0308      13.9298      29.3296      27.6222     311.0000      86.1738     616.1922       0.1565       0.1258     187.0785       0.2130       0.2648       6.0595    2442.4448     -10.1875    3800.0000
 1895.2464      22.8453      23.6363      29.5768      36.1289      34.4133     311.0000      93.2370     616.1922       0.1099       0.0775     207.0987       0.2022       0.2539       5.7705    2522.0886     -10.0625    3826.0000
 1895.3988      20.6407      25.6535      47.1473      34.5173      33.4067     311.0000      94.9811     616.4654       0.1582       0.1276     225.7409       0.2247       0.2760       6.0232    2439.4146      -9.8750    3889.0000
 1895.5512      22.2145      36.3922      36.9848      29.5700      28.0528     311.0000      91.7373     614.7354       0.1485       0.1175     208.5626       0.2527       0.3030       6.4293    2456.1458      -8.7500    3800.0000
 1895.7036      23.0836      29.3358      49.7945      44.1926      43.2546     311.0000      91.4127     616.1922       0.2023       0.1733     184.2768       0.3054       0.3539       5.6451    2364.0481      -9.0000    3785.0000
 1895.8560      40.0136      28.8016      42.4579      61.3212      57.7299     311.0000      91.0596     584.7791       0.2208       0.1925     158.2623       0.2957       0.3441       6.0915    2332.3713      -8.6875    3772.0000
 1896.0084      23.1712      16.4144      26.7033      86.3152      77.0144     311.0000      93.8851     613.2785       0.1560       0.1253     180.8271       0.3251       0.3722       5.3526    2443.2305      -7.4375    3864.0000
 1896.1608      12.0749      10.5344      15.1918      63.5318      57.4455     311.0000      93.6527     616.1922       0.1559       0.1252     211.8676       0.2935       0.3415       6.4215    2443.3679      -5.3125    3917.0000
 1896.3132      11.5015      11.2693      20.7313      51.6819      47.2353     311.0000      97.3291     604.7196       0.0797       0.0462     236.9061       0.2623       0.3121       5.9897    2573.7366      -4.7500    3881.0000
 1896.4656      14.5794      14.6893      21.6317      35.8350      33.7672     311.0000     100.2511     604.1733       0.0933       0.0603     243.3445       0.2637       0.3141       5.7247    2550.4919      -3.5625    3811.0000
 1896.6180      15.2921      18.0574      27.0658      29.5987      28.2491     311.0000      98.2638     616.4654       0.1104       0.0781     258.0573       0.2650       0.3154       5.8857    2521.1592      -3.3125    3778.0000
 1896.7704      12.7745      17.7251      23.2062      29.6869      28.4208     311.0000      96.1174     616.1922       0.1715       0.1414     257.7214       0.2495       0.2997       6.2465    2416.7622      -2.6875    3751.0000
 1896.9228      14.3381      15.6341      23.2800      32.4404      31.0363     311.0000      94.6950     616.1922       0.1718       0.1417     251.4665       0.2285       0.2796       6.3136    2416.1777      -2.3125    3793.0000
 1897.0752      16.2896      15.2589      34.6159      47.8079      45.9968     311.0000      93.8856     616.1922       0.1701       0.1399     237.2892       0.2391       0.2910       6.4059    2419.1985      -1.4375    3903.0000
 1897.2276      13.2495      13.2814      21.8137      49.9977      48.6358     311.0000      91.5987     616.1922       0.1493       0.1184     233.3026       0.2518       0.3035       5.9770    2454.6345      -1.4375    3841.0000
 1897.3800      14.4581      13.7025      25.9026      57.4363      57.0316     311.0000      91.2744     616.5565       0.1374       0.1060     234.1909       0.2407       0.2927       5.8247    2475.1206      -1.4375    3893.0000
 1897.5324      10.2537      12.2606      27.0275      49.5804      49.7486     311.0000      93.5462     616.1922       0.1064       0.0739     241.3235       0.1872       0.2381       6.0443    2527.9883      -1.4375    3863.0000
 1897.6848      15.0186      13.1948      14.3630      31.7708      32.1046     311.0000      98.8444     616.1922       0.0573       0.0230     255.3637       0.2083       0.2601       5.7843    2611.9817      -1.4375    3865.0000
 1897.8372      13.9238      12.9388      21.0746      26.1342      26.6938     311.0000     102.0747     616.1922       0.0860       0.0528     266.4475       0.1958       0.2466       5.4832    2562.9026      -1.8750    3879.0000
 1897.9896      18.0192      19.7350      38.1133      40.2155      41.0402     311.0000     102.4914     616.1922       0.1250       0.0932     260.1133       0.2161       0.2679       6.3854    2496.1658      -2.2500    3818.0000
 1898.1420      15.0074      20.1325      29.1155      27.6387      28.6344     311.0000      98.6145     616.4654       0.0784       0.0449     252.9469       0.2110       0.2626       5.5746    2575.8965      -2.4375    3793.0000
 1898.2944      13.1804      15.7732      21.5486      18.3409      18.8632     311.0000      96.0331     616.3743       0.0843       0.0510     231.7014       0.1778       0.2287       5.4109    2565.8005      -1.5000    3695.0000
 1898.4468       9.4866      11.2048      12.2866      18.9926      19.6849     311.0000      93.5461     616.1922       0.0653       0.0313     197.8204       0.1975       0.2489       5.3935    2598.3931      -1.4375    3726.0000
 1898.5992       9.2093       9.8952      10.2608      11.6576      12.0163     311.0000      94.9904     616.4654       0.1732       0.1432     149.0924       0.2368       0.2889       5.0779    2413.7612      -1.4375    3923.0000
 1898.7516      14.5700      19.6760      20.2209      22.4633      23.3536     311.0000      94.0173     616.5565       0.1013       0.0686      90.8558       0.2158       0.2675       5.1051    2536.7915      -1.4375    4003.0000
 1898.9040      21.0261      21.1804      27.8197      26.4112      27.3699     311.0000      94.5729     616.1922       0.1017       0.0691      73.7197       0.2279       0.2799       4.9763    2536.0198      -1.4375    3855.0000
 1899.0564      16.8598      16.0150      19.3118      22.6173      23.7746     311.0000      92.7014     616.1922       0.1069       0.0745      92.3517       0.2252       0.2767       5.0466    2527.1265      -0.0625    3890.0000
 1899.2088      14.1144      13.1174      16.3798      25.6880      27.0615     311.0000      93.9989     616.1922       0.1558       0.1251     150.2473       0.2906       0.3424       5.4604    2443.6396      -0.8750    3792.0000
 1899.3612       9.5435      12.1997      15.2383      33.6999      35.9185     311.0000      96.3789     616.1922       0.1474       0.1164     202.5976       0.2719       0.3227       5.8489    2457.9043       0.4375    3818.0000
 1899.5136      13.3183      12.1979      16.6880      40.6738      42.8044     311.0000      94.5198     616.1922       0.1246       0.0928     237.7250       0.2344       0.2846       5.8666    2496.9407      -0.3750    3917.0000
 1899.6660      15.4454      12.9262      18.4038      39.5305      40.9238     311.0000      92.2391     616.1922       0.0950       0.0621     258.2903       0.3145       0.3653       5.5998    2547.5488      -0.0625    3850.0000
 1899.8184      13.9076      12.8299      19.5318      25.1221      25.7496     311.0000      92.5636     616.3743       0.1003       0.0676     244.4110       0.2660       0.3174       5.5455    2538.4844      -0.1250    3812.0000
 1899.9708       7.2927       6.3925       7.1755       9.2236       9.3465     311.0000      98.5106     616.4654       0.1064       0.0739     213.1534       0.2431       0.2943       5.4711    2527.9954       0.5000    3739.0000
 1900.1232      12.8246      12.8358      20.8858      22.6512      23.1056     311.0000      94.7495     616.5565       0.0997       0.0669     181.8025       0.2525       0.3030       5.5724    2539.5579      -0.0625    3787.0000
 1900.2756      10.1146      15.3185      19.9404      31.8312      32.4665     311.0000      91.4894     616.1922       0.1361       0.1047     175.5617       0.2547       0.3053       5.6781    2477.2324       0.5000    3858.0000
 1900.4280      12.5744      12.4547      15.2194      26.2951      26.6930     311.0000      88.9106     616.1922       0.1481       0.1172     186.0192       0.2405       0.2910       6.1090    2456.6672       1.0000    3876.0000
 1900.5804      12.5794      10.4256      12.2005      15.1010      15.3376     311.0000      97.3065     616.3743       0.1444       0.1133     189.4808       0.2584       0.3088       6.0653    2463.1072       1.2500    3787.0000
 1900.7328      11.8382      10.7889      13.2360      18.1204      18.4402     311.0000     101.5235     616.4654       0.1303       0.0987     189.4441       0.2580       0.3084       5.8084    2487.1951       2.2500    3833.0000
 1900.8852      10.9787       8.8628      15.5263      19.6571      19.9925     311.0000     105.6922     616.7385       0.1177       0.0857     199.2514       0.2261       0.2759       6.0733    2508.6499       2.3125    3923.0000
 1901.0376      12.8139      10.6018      12.1009      18.4996      18.7006     311.0000      99.3517     616.1922       0.0886       0.0555     207.4165       0.2574       0.3070       5.5839    2558.4849       2.0000    3816.0000
 1901.1900       9.3783       8.9445      16.8293      27.4342      27.6686     311.0000      99.0273     616.3743       0.1785       0.1486     215.6415       0.2237       0.2734       5.7408    2404.7539       3.6250    3772.0000
 1901.3424      17.6591      13.3297      20.1866      36.8788      36.9680     311.0000      94.9668     605.6301       0.1618       0.1313     207.3190       0.3148       0.3655       6.2634    2433.3750       3.2500    3977.0000
 1901.4948      12.1462      10.3611      17.6721      29.6185      29.7180     311.0000     100.3803     616.1922       0.1342       0.1027     198.8838       0.2532       0.3045       5.6049    2480.5674       2.1875    3997.0000
 1901.6472      12.9086       9.1110      11.8503      18.7701      18.7117     311.0000     101.4616     616.4654       0.1076       0.0752     181.1519       0.2843       0.3356       5.4470    2525.9556       1.6875    3849.0000
 1901.7996      10.4101       8.6838      14.2166      25.2238      25.1417     311.0000     100.3798     616.3743       0.1562       0.1255     172.6723       0.2544       0.3054       5.5708    2442.8948       1.6250    3785.0000
 1901.9520      11.2797      10.9888      14.9932      31.3463      31.0639     311.0000     101.4395     616.1922       0.1893       0.1598     186.3666       0.2160       0.2663       6.0264    2386.2507       1.3125    3819.0000
 1902.1044       8.8178      10.0520      13.3383      25.9633      25.7244     311.0000      99.6226     616.4654       0.1856       0.1560     218.5247       0.2888       0.3400       5.5016    2392.6035       0.6250    3777.0000
 1902.2568      11.9924      10.8466      19.5992      41.3797      40.5010     311.0000      99.5144     616.4654       0.1811       0.1514     251.9012       0.2870       0.3378       6.2199    2400.2549      -0.3750    3796.0000
 1902.4092      11.2361      13.3406      19.5703      48.6456      47.3670     311.0000      98.5413     616.1922       0.1424       0.1112     273.5987       0.2394       0.2903       6.3316    2466.5403      -0.9375    3803.0000
 1902.5616      10.0732      10.3732      18.3582      39.5628      38.9613     311.0000      96.8054     616.3743       0.0742       0.0405     279.6021       0.2708       0.3211       6.0541    2583.1392      -1.4375    3795.0000
 1902.7140      12.1937      12.8832       9.5857      16.9550      16.6986     311.0000     101.9798     616.5565       0.0821       0.0487     267.7736       0.2660       0.3164       5.3645    2569.6563      -1.4375    3754.0000
 1902.8664      10.7656       9.6070      13.7566      29.1283      28.6864     311.0000     102.9706     616.1922       0.0947       0.0618     248.0745       0.2731       0.3225       5.6064    2548.0823      -1.4375    3800.0000
 1903.0188      12.1273      13.7939      11.1795      19.6152      19.3670     311.0000     100.8827     616.1922       0.0571       0.0229     217.7136       0.2609       0.3115       5.8783    2612.2813      -1.4375    3817.0000
 1903.1712      11.6674      12.0705      17.0253      27.8914      27.4682     311.0000     101.1174     616.1922       0.0136      -0.0223     183.6047       0.2479       0.2987       5.1252    2686.7910      -1.4375    3790.0000
 1903.3236       9.1269      15.2497      17.5635      23.4277      23.0465     311.0000     100.6672     616.1922       0.0540       0.0196     154.5165       0.2355       0.2865       4.7360    2617.6680      -1.4375    3708.0000
 1903.4760      10.3567      10.1082      20.8236      24.4443      23.9794     311.0000     103.9116     616.7385       0.0834       0.0500     146.0996       0.2426       0.2934       5.0512    2567.4292      -1.4375    3774.0000
 1903.6284      14.0164      14.1042      11.8034      13.9537      13.6976     311.0000     101.4235     616.1922       0.0402       0.0053     143.4274       0.2677       0.3180       5.0249    2641.2996      -1.4375    3751.0000
 1903.7808      13.6949      10.3477      18.5292      21.7784      21.5174     311.0000      99.8016     616.1922       0.0579       0.0237     139.9307       0.2718       0.3225       5.1603    2610.9578      -1.4375    3765.0000
 1903.9332      14.0403      16.8918      15.3780      21.9973      21.7007     311.0000     101.3079     616.4654       0.0780       0.0445     136.6517       0.2638       0.3150       5.0968    2576.5752      -1.3125    3804.0000
 1904.0856      11.1078      17.6072      19.4466      31.5295      31.0379     311.0000      99.1443     616.4654       0.1053       0.0728     140.0452       0.2853       0.3366       5.0967    2529.8896       0.0000    3706.0000
 1904.2380      10.6603      11.4986      15.0168      28.5613      28.3393     311.0000      98.2792     616.4654       0.0769       0.0433     139.1838       0.2772       0.3275       5.2175    2578.4773      -0.6875    3715.0000
 1904.3904       9.7029      11.0738      14.7380      18.8319      18.5959     311.0000      98.5110     616.3743       0.0670       0.0330     129.7443       0.2529       0.3026       4.8883    2595.5144      -1.0625    3680.0000
 1904.5428      11.2387      12.6390      18.1816      17.4131      17.2293     311.0000     100.0395     616.3743       0.1133       0.0811     122.8561       0.2454       0.2956       4.9589    2516.2239      -0.5625    3699.0000
 1904.6952      12.2984      14.6809      21.0944      18.0882      17.9181     311.0000     100.8564     616.1922       0.0992       0.0664     698.6644       0.2716       0.3218       5.0361    2540.3826      -0.0625    3670.0000
 1904.8476       8.9930      11.5398      13.4457      14.8222      14.7300     311.0000     102.0727     616.3743       0.0819       0.0485    1571.2386       0.2541       0.3040       4.7704    2569.9812      -1.0625    3688.0000
 1905.0000      16.1212      20.9368      23.3532      24.4325      24.2851     311.0000     101.8256     616.5565       0.0324      -0.0028    2444.9683       0.2660       0.3161       4.6384    2654.6108       1.1875    3670.0000
 1905.1524      11.7027      20.7769      23.4906      30.4547      30.1966     311.0000     103.0804     616.4654     585.9415     607.2121 -999250.0000       0.2692       0.3208    -999.2500 -999250.0000       0.8750    3687.0000
 1905.3048      12.5051      13.0662      16.6143      21.3703      21.2163     311.0000     101.8735     616.1922     585.9415     607.2121 -999250.0000       0.2275       0.2787    -999.2500 -999250.0000       1.1875    3763.0000
 1905.4572       6.5558       5.2892       6.2438       7.9964       7.9457     311.0000     103.1884     616.1922     585.9415     607.2121 -999250.0000       0.2746       0.3256    -999.2500 -999250.0000      -0.1875    3863.0000
 1905.6096      14.7041      13.4829      16.7437      20.4416      20.2917     311.0000      98.3416     616.5565     585.9415     607.2121 -999250.0000       0.2765       0.3281    -999.2500 -999250.0000      -0.1875    3818.0000
 1905.7620      14.3452      29.9060      25.6778      25.8158      25.5893     311.0000      95.3140     616.3743     585.9415     607.2121 -999250.0000       0.2008       0.2523    -999.2500 -999250.0000      -0.8750    3698.0000
 1905.9144      17.0119      22.0637      21.5769      18.4934      18.3218     311.0000      93.3668     616.1922     585.9415     607.2121 -999250.0000       0.1675       0.2183    -999.2500 -999250.0000       0.0000    3517.0000
 1906.0668      16.1367      22.7119      19.5075      16.3980      16.2470     311.0000      93.3668     616.1922     585.9415     607.2121 -999250.0000       0.1631       0.2137    -999.2500 -999250.0000       0.0000    3517.0000
